/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.discovery.HostnameResolver;
import org.neo4j.causalclustering.discovery.RemoteMembersResolver;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.kernel.configuration.Config;

public class InitialDiscoveryMembersResolver
implements RemoteMembersResolver {
    private final HostnameResolver hostnameResolver;
    private final List<AdvertisedSocketAddress> advertisedSocketAddresses;

    public InitialDiscoveryMembersResolver(HostnameResolver hostnameResolver, Config config) {
        this.hostnameResolver = hostnameResolver;
        this.advertisedSocketAddresses = (List)config.get(CausalClusteringSettings.initial_discovery_members);
    }

    public <T> Collection<T> resolve(Function<AdvertisedSocketAddress, T> transform) {
        return this.advertisedSocketAddresses.stream().flatMap(raw -> this.hostnameResolver.resolve((AdvertisedSocketAddress)raw).stream()).map(transform).collect(Collectors.toSet());
    }
}

