/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.discovery.MultiRetryStrategy;
import org.neo4j.causalclustering.discovery.RemoteMembersResolver;
import org.neo4j.causalclustering.discovery.RetryingHostnameResolver;
import org.neo4j.causalclustering.discovery.SecurePassword;
import org.neo4j.causalclustering.discovery.kubernetes.KubernetesType;
import org.neo4j.causalclustering.discovery.kubernetes.ServiceList;
import org.neo4j.causalclustering.discovery.kubernetes.Status;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.Log;
import org.neo4j.logging.internal.LogService;
import org.neo4j.util.Preconditions;

public class KubernetesResolver
implements RemoteMembersResolver {
    private final KubernetesClient kubernetesClient;
    private final HttpClient httpClient;
    private final Log log;

    private KubernetesResolver(LogService logService, Config config) {
        this.log = logService.getInternalLog(this.getClass());
        SslContextFactory sslContextFactory = this.createSslContextFactory(config);
        this.httpClient = new HttpClient(sslContextFactory);
        String token = this.read((File)config.get(CausalClusteringSettings.kubernetes_token));
        String namespace = this.read((File)config.get(CausalClusteringSettings.kubernetes_namespace));
        this.kubernetesClient = new KubernetesClient(logService, this.httpClient, token, namespace, config, RetryingHostnameResolver.defaultRetryStrategy(config, logService.getInternalLogProvider()));
    }

    public static RemoteMembersResolver resolver(LogService logService, Config config) {
        return new KubernetesResolver(logService, config);
    }

    /*
     * Exception decompiling
     */
    private SslContextFactory createSslContextFactory(Config config) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private KeyStore loadKeyStore(SecurePassword password, InputStream caCertStream) throws CertificateException, KeyStoreException, IOException, NoSuchAlgorithmException {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        Collection<? extends Certificate> certificates = certificateFactory.generateCertificates(caCertStream);
        Preconditions.checkState((!certificates.isEmpty() ? 1 : 0) != 0, (String)"Expected non empty Kubernetes CA certificates");
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(null, password.password());
        int idx = 0;
        for (Certificate certificate : certificates) {
            keyStore.setCertificateEntry("ca" + idx++, certificate);
        }
        return keyStore;
    }

    private String read(File file) {
        try {
            Optional<String> line = Files.lines(file.toPath()).findFirst();
            if (line.isPresent()) {
                return line.get();
            }
            throw new IllegalStateException(String.format("Expected file at %s to have at least 1 line", file));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to read file " + file, e);
        }
    }

    public <T> Collection<T> resolve(Function<AdvertisedSocketAddress, T> transform) {
        try {
            this.httpClient.start();
            Collection collection = this.kubernetesClient.resolve(null).stream().map(transform).collect(Collectors.toList());
            return collection;
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to query Kubernetes API", e);
        }
        finally {
            try {
                this.httpClient.stop();
            }
            catch (Exception e) {
                this.log.warn("Unable to shut down HTTP client", (Throwable)e);
            }
        }
    }

    private static class Parser
    implements KubernetesType.Visitor<Collection<AdvertisedSocketAddress>> {
        private final String portName;
        private final String namespace;

        private Parser(String portName, String namespace) {
            this.portName = portName;
            this.namespace = namespace;
        }

        @Override
        public Collection<AdvertisedSocketAddress> visit(Status status) {
            String message = String.format("Unable to contact Kubernetes API. Status: %s", status);
            throw new IllegalStateException(message);
        }

        @Override
        public Collection<AdvertisedSocketAddress> visit(ServiceList serviceList) {
            Stream<AdvertisedSocketAddress> serviceNamePortStream = serviceList.items().stream().filter(this::notDeleted).flatMap(this::extractServicePort);
            return serviceNamePortStream.map(serviceNamePort -> new AdvertisedSocketAddress(String.format("%s.%s.svc.cluster.local", serviceNamePort.first(), this.namespace), ((ServiceList.Service.ServiceSpec.ServicePort)serviceNamePort.other()).port())).collect(Collectors.toSet());
        }

        private boolean notDeleted(ServiceList.Service service) {
            return service.metadata().deletionTimestamp() == null;
        }

        private Stream<Pair<String, ServiceList.Service.ServiceSpec.ServicePort>> extractServicePort(ServiceList.Service service) {
            return service.spec().ports().stream().filter(port -> this.portName.equals(port.name())).map(port -> Pair.of((Object)service.metadata().name(), (Object)port));
        }
    }

    static class KubernetesClient
    extends RetryingHostnameResolver {
        static final String path = "/api/v1/namespaces/%s/services";
        private final Log log;
        private final Log userLog;
        private final HttpClient httpClient;
        private final String token;
        private final String namespace;
        private final String labelSelector;
        private final ObjectMapper objectMapper;
        private final String portName;
        private final AdvertisedSocketAddress kubernetesAddress;

        KubernetesClient(LogService logService, HttpClient httpClient, String token, String namespace, Config config, MultiRetryStrategy<AdvertisedSocketAddress, Collection<AdvertisedSocketAddress>> retryStrategy) {
            super(config, retryStrategy);
            this.log = logService.getInternalLog(this.getClass());
            this.userLog = logService.getUserLog(this.getClass());
            this.token = token;
            this.namespace = namespace;
            this.kubernetesAddress = (AdvertisedSocketAddress)config.get(CausalClusteringSettings.kubernetes_address);
            this.labelSelector = (String)config.get(CausalClusteringSettings.kubernetes_label_selector);
            this.portName = (String)config.get(CausalClusteringSettings.kubernetes_service_port_name);
            this.httpClient = httpClient;
            this.objectMapper = new ObjectMapper().configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        }

        @Override
        protected Collection<AdvertisedSocketAddress> resolveOnce(AdvertisedSocketAddress ignored) {
            try {
                ContentResponse response = this.httpClient.newRequest(this.kubernetesAddress.getHostname(), this.kubernetesAddress.getPort()).method(HttpMethod.GET).scheme("https").path(String.format(path, this.namespace)).param("labelSelector", this.labelSelector).header(HttpHeader.AUTHORIZATION, "Bearer " + this.token).accept(new String[]{MimeTypes.Type.APPLICATION_JSON.asString()}).send();
                this.log.info("Received from k8s api \n" + response.getContentAsString());
                KubernetesType serviceList = (KubernetesType)this.objectMapper.readValue(response.getContent(), KubernetesType.class);
                Collection<AdvertisedSocketAddress> addresses = serviceList.handle(new Parser(this.portName, this.namespace));
                this.userLog.info("Resolved %s from Kubernetes API at %s namespace %s labelSelector %s", new Object[]{addresses, this.kubernetesAddress, this.namespace, this.labelSelector});
                if (addresses.isEmpty()) {
                    this.log.error("Resolved empty hosts from Kubernetes API at %s namespace %s labelSelector %s", new Object[]{this.kubernetesAddress, this.namespace, this.labelSelector});
                }
                return addresses;
            }
            catch (IOException e) {
                this.log.error("Failed to parse result from Kubernetes API", (Throwable)e);
                return Collections.emptySet();
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                this.log.error(String.format("Failed to resolve hosts from Kubernetes API at %s namespace %s labelSelector %s", this.kubernetesAddress, this.namespace, this.labelSelector), (Throwable)e);
                return Collections.emptySet();
            }
        }
    }
}

