/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import java.time.Duration;
import java.util.Collection;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.discovery.HostnameResolver;
import org.neo4j.causalclustering.discovery.MultiRetryStrategy;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.LogProvider;

public abstract class RetryingHostnameResolver
implements HostnameResolver {
    private final int minResolvedAddresses;
    private final MultiRetryStrategy<AdvertisedSocketAddress, Collection<AdvertisedSocketAddress>> retryStrategy;

    RetryingHostnameResolver(Config config, MultiRetryStrategy<AdvertisedSocketAddress, Collection<AdvertisedSocketAddress>> retryStrategy) {
        this.minResolvedAddresses = (Integer)config.get(CausalClusteringSettings.minimum_core_cluster_size_at_formation);
        this.retryStrategy = retryStrategy;
    }

    static MultiRetryStrategy<AdvertisedSocketAddress, Collection<AdvertisedSocketAddress>> defaultRetryStrategy(Config config, LogProvider logProvider) {
        long retryIntervalMillis = ((Duration)config.get(CausalClusteringSettings.discovery_resolution_retry_interval)).toMillis();
        long clusterBindingTimeout = ((Duration)config.get(CausalClusteringSettings.discovery_resolution_timeout)).toMillis();
        long numRetries = clusterBindingTimeout / retryIntervalMillis + 1L;
        return new MultiRetryStrategy<AdvertisedSocketAddress, Collection<AdvertisedSocketAddress>>(retryIntervalMillis, numRetries, logProvider, RetryingHostnameResolver::sleep);
    }

    @Override
    public final Collection<AdvertisedSocketAddress> resolve(AdvertisedSocketAddress advertisedSocketAddress) {
        return this.retryStrategy.apply(advertisedSocketAddress, this::resolveOnce, addrs -> addrs.size() >= this.minResolvedAddresses);
    }

    protected abstract Collection<AdvertisedSocketAddress> resolveOnce(AdvertisedSocketAddress var1);

    private static void sleep(long durationInMillis) {
        try {
            Thread.sleep(durationInMillis);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

