/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.Optional;
import java.util.Properties;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import org.neo4j.causalclustering.discovery.SrvRecordResolver;

public class SrvRecordResolverImpl
extends SrvRecordResolver {
    private final String[] SRV_RECORDS = new String[]{"SRV"};
    private final String SRV_ATTR = "srv";
    private Optional<InitialDirContext> _idc = Optional.empty();

    @Override
    public Stream<SrvRecordResolver.SrvRecord> resolveSrvRecord(String url) throws NamingException {
        Attributes attrs = this._idc.orElseGet(this::setIdc).getAttributes(url, this.SRV_RECORDS);
        return SrvRecordResolverImpl.enumerationAsStream(attrs.get("srv").getAll()).map(SrvRecordResolver.SrvRecord::parse);
    }

    private synchronized InitialDirContext setIdc() {
        return this._idc.orElseGet(() -> {
            Properties env = new Properties();
            env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
            try {
                this._idc = Optional.of(new InitialDirContext(env));
                return this._idc.get();
            }
            catch (NamingException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private static <T> Stream<T> enumerationAsStream(final Enumeration<T> e) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new Iterator<T>(){

            @Override
            public T next() {
                return e.nextElement();
            }

            @Override
            public boolean hasNext() {
                return e.hasMoreElements();
            }
        }, 16), false);
    }
}

