/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.handlers;

import io.netty.channel.ChannelHandlerAdapter;
import io.netty.channel.ChannelHandlerContext;
import org.neo4j.logging.Log;

public class ExceptionLoggingHandler
extends ChannelHandlerAdapter {
    private final Log log;

    public ExceptionLoggingHandler(Log log) {
        this.log = log;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (ctx != null) {
            this.log.error(String.format("Failed to process message on channel %s.", ctx.channel()), cause);
            ctx.fireExceptionCaught(cause);
        } else {
            this.log.error("Failed to process message on a null channel.", cause);
        }
    }
}

