/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.helper;

import java.util.concurrent.TimeUnit;
import org.neo4j.function.ThrowingAction;
import org.neo4j.logging.Log;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.JobScheduler;

public class RobustJobSchedulerWrapper {
    private final JobScheduler delegate;
    private final Log log;

    public RobustJobSchedulerWrapper(JobScheduler delegate, Log log) {
        this.delegate = delegate;
        this.log = log;
    }

    public JobHandle schedule(Group group, long delayMillis, ThrowingAction<Exception> action) {
        return this.delegate.schedule(group, () -> this.withErrorHandling(action), delayMillis, TimeUnit.MILLISECONDS);
    }

    public JobHandle scheduleRecurring(Group group, long periodMillis, ThrowingAction<Exception> action) {
        return this.delegate.scheduleRecurring(group, () -> this.withErrorHandling(action), periodMillis, TimeUnit.MILLISECONDS);
    }

    private void withErrorHandling(ThrowingAction<Exception> action) {
        try {
            action.apply();
        }
        catch (Exception e) {
            this.log.warn("Uncaught exception", (Throwable)e);
        }
        catch (Throwable t) {
            this.log.error("Uncaught error rethrown", t);
            throw t;
        }
    }
}

