/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.management;

import java.io.File;
import java.util.EnumSet;
import org.neo4j.causalclustering.core.consensus.RaftMachine;
import org.neo4j.causalclustering.core.state.ClusterStateDirectory;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.jmx.impl.ManagementBeanProvider;
import org.neo4j.jmx.impl.ManagementData;
import org.neo4j.jmx.impl.Neo4jMBean;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.impl.factory.OperationalMode;
import org.neo4j.management.CausalClustering;

public class CausalClusteringBean
extends ManagementBeanProvider {
    private static final EnumSet<OperationalMode> CLUSTERING_MODES = EnumSet.of(OperationalMode.core, OperationalMode.read_replica);

    public CausalClusteringBean() {
        super(CausalClustering.class);
    }

    protected Neo4jMBean createMBean(ManagementData management) {
        if (CausalClusteringBean.isCausalClustering(management)) {
            return new CausalClusteringBeanImpl(management, false);
        }
        return null;
    }

    protected Neo4jMBean createMXBean(ManagementData management) {
        if (CausalClusteringBean.isCausalClustering(management)) {
            return new CausalClusteringBeanImpl(management, true);
        }
        return null;
    }

    private static boolean isCausalClustering(ManagementData management) {
        DatabaseInfo databaseInfo = (DatabaseInfo)management.resolveDependency(DatabaseInfo.class);
        return CLUSTERING_MODES.contains(databaseInfo.operationalMode);
    }

    private static class CausalClusteringBeanImpl
    extends Neo4jMBean
    implements CausalClustering {
        private final ClusterStateDirectory clusterStateDirectory;
        private final RaftMachine raftMachine;
        private final FileSystemAbstraction fs;

        CausalClusteringBeanImpl(ManagementData management, boolean isMXBean) {
            super(management, isMXBean, new String[0]);
            this.clusterStateDirectory = (ClusterStateDirectory)management.resolveDependency(ClusterStateDirectory.class);
            this.raftMachine = (RaftMachine)management.resolveDependency(RaftMachine.class);
            this.fs = management.getKernelData().getFilesystemAbstraction();
        }

        public String getRole() {
            return this.raftMachine.currentRole().toString();
        }

        public long getRaftLogSize() {
            File raftLogDirectory = new File(this.clusterStateDirectory.get(), "raft-log");
            return FileUtils.size((FileSystemAbstraction)this.fs, (File)raftLogDirectory);
        }

        public long getReplicatedStateSize() {
            File replicatedStateDirectory = this.clusterStateDirectory.get();
            File[] files = this.fs.listFiles(replicatedStateDirectory);
            if (files == null) {
                return 0L;
            }
            long size = 0L;
            for (File file : files) {
                if (this.fs.isDirectory(file) && file.getName().equals("raft-log")) continue;
                size += FileUtils.size((FileSystemAbstraction)this.fs, (File)file);
            }
            return size;
        }
    }
}

