/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.messaging;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.util.Objects;
import java.util.Queue;
import org.neo4j.storageengine.api.WritableChannel;

public class ChunkingNetworkChannel
implements WritableChannel,
AutoCloseable {
    private static final int DEFAULT_INIT_CHUNK_SIZE = 512;
    private final ByteBufAllocator allocator;
    private final int maxChunkSize;
    private final int initSize;
    private final Queue<ByteBuf> byteBufs;
    private ByteBuf current;
    private boolean isClosed;

    public ChunkingNetworkChannel(ByteBufAllocator allocator, int maxChunkSize, Queue<ByteBuf> outputQueue) {
        Objects.requireNonNull(allocator, "allocator cannot be null");
        Objects.requireNonNull(outputQueue, "outputQueue cannot be null");
        this.allocator = allocator;
        this.maxChunkSize = maxChunkSize;
        this.initSize = Integer.min(512, maxChunkSize);
        if (maxChunkSize < 8) {
            throw new IllegalArgumentException("Chunk size must be at least 8. Got " + maxChunkSize);
        }
        this.byteBufs = outputQueue;
    }

    public WritableChannel put(byte value) {
        this.checkState();
        this.prepareWrite(1);
        this.current.writeByte((int)value);
        return this;
    }

    public WritableChannel putShort(short value) {
        this.checkState();
        this.prepareWrite(2);
        this.current.writeShort((int)value);
        return this;
    }

    public WritableChannel putInt(int value) {
        this.checkState();
        this.prepareWrite(4);
        this.current.writeInt(value);
        return this;
    }

    public WritableChannel putLong(long value) {
        this.checkState();
        this.prepareWrite(8);
        this.current.writeLong(value);
        return this;
    }

    public WritableChannel putFloat(float value) {
        this.checkState();
        this.prepareWrite(4);
        this.current.writeFloat(value);
        return this;
    }

    public WritableChannel putDouble(double value) {
        this.checkState();
        this.prepareWrite(8);
        this.current.writeDouble(value);
        return this;
    }

    public WritableChannel put(byte[] value, int length) {
        this.checkState();
        int writeIndex = 0;
        int remaining = length;
        while (remaining != 0) {
            int toWrite = this.prepareGently(remaining);
            ByteBuf current = this.getOrCreateCurrent();
            current.writeBytes(value, writeIndex, toWrite);
            remaining = length - (writeIndex += toWrite);
        }
        return this;
    }

    public WritableChannel flush() {
        this.storeCurrent();
        return this;
    }

    private int prepareGently(int size) {
        if (this.getOrCreateCurrent().writerIndex() == this.maxChunkSize) {
            this.prepareWrite(size);
        }
        return Integer.min(this.maxChunkSize - this.current.writerIndex(), size);
    }

    private ByteBuf getOrCreateCurrent() {
        if (this.current == null) {
            this.current = this.allocateNewBuffer();
        }
        return this.current;
    }

    private void prepareWrite(int size) {
        if (this.getOrCreateCurrent().writerIndex() + size > this.maxChunkSize) {
            this.storeCurrent();
        }
        this.getOrCreateCurrent();
    }

    private void storeCurrent() {
        if (this.current == null) {
            return;
        }
        try {
            while (!this.byteBufs.offer(this.current)) {
                Thread.sleep(10L);
            }
            this.current = null;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Unable to flush. Thread interrupted");
        }
    }

    private void releaseCurrent() {
        if (this.current != null) {
            this.current.release();
        }
    }

    private ByteBuf allocateNewBuffer() {
        return this.allocator.buffer(this.initSize, this.maxChunkSize);
    }

    private void checkState() {
        if (this.isClosed) {
            throw new IllegalStateException("Channel has been closed already");
        }
    }

    @Override
    public void close() {
        try {
            this.flush();
        }
        finally {
            this.isClosed = true;
            this.releaseCurrent();
        }
    }

    public boolean closed() {
        return this.isClosed;
    }
}

