/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.messaging;

import io.netty.buffer.ByteBuf;
import org.neo4j.causalclustering.messaging.ByteBufBacked;
import org.neo4j.storageengine.api.WritableChannel;

public class NetworkWritableChannel
implements WritableChannel,
ByteBufBacked {
    private final ByteBuf delegate;

    public NetworkWritableChannel(ByteBuf byteBuf) {
        this.delegate = byteBuf;
    }

    public WritableChannel put(byte value) {
        this.delegate.writeByte((int)value);
        return this;
    }

    public WritableChannel putShort(short value) {
        this.delegate.writeShort((int)value);
        return this;
    }

    public WritableChannel putInt(int value) {
        this.delegate.writeInt(value);
        return this;
    }

    public WritableChannel putLong(long value) {
        this.delegate.writeLong(value);
        return this;
    }

    public WritableChannel putFloat(float value) {
        this.delegate.writeFloat(value);
        return this;
    }

    public WritableChannel putDouble(double value) {
        this.delegate.writeDouble(value);
        return this;
    }

    public WritableChannel put(byte[] value, int length) {
        this.delegate.writeBytes(value, 0, length);
        return this;
    }

    @Override
    public ByteBuf byteBuf() {
        return this.delegate;
    }
}

