/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.messaging.marshalling;

import java.util.function.Function;

public class ContentBuilder<CONTENT> {
    private boolean isComplete;
    private Function<CONTENT, CONTENT> contentFunction;

    public static <C> ContentBuilder<C> emptyUnfinished() {
        return new ContentBuilder<Object>(content -> content, false);
    }

    public static <C> ContentBuilder<C> unfinished(Function<C, C> contentFunction) {
        return new ContentBuilder<C>(contentFunction, false);
    }

    public static <C> ContentBuilder<C> finished(C content) {
        return new ContentBuilder<Object>(ignored -> content, true);
    }

    private ContentBuilder(Function<CONTENT, CONTENT> contentFunction, boolean isComplete) {
        this.contentFunction = contentFunction;
        this.isComplete = isComplete;
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    public ContentBuilder<CONTENT> combine(ContentBuilder<CONTENT> contentBuilder) {
        if (this.isComplete) {
            throw new IllegalStateException("This content builder has already completed and cannot be combined.");
        }
        this.contentFunction = this.contentFunction.compose(contentBuilder.contentFunction);
        this.isComplete = contentBuilder.isComplete;
        return this;
    }

    public CONTENT build() {
        if (!this.isComplete) {
            throw new IllegalStateException("Cannot build unfinished content");
        }
        return this.contentFunction.apply(null);
    }
}

