/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.messaging.marshalling.v2.decoding;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.ReferenceCountUtil;
import org.neo4j.causalclustering.catchup.Protocol;
import org.neo4j.causalclustering.messaging.marshalling.v2.ContentType;

public class ContentTypeDispatcher
extends ChannelInboundHandlerAdapter {
    private final Protocol<ContentType> contentTypeProtocol;

    public ContentTypeDispatcher(Protocol<ContentType> contentTypeProtocol) {
        this.contentTypeProtocol = contentTypeProtocol;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof ByteBuf) {
            ByteBuf buffer = (ByteBuf)msg;
            if (this.contentTypeProtocol.isExpecting(ContentType.ContentType)) {
                byte messageCode = buffer.readByte();
                ContentType contentType = this.getContentType(messageCode);
                this.contentTypeProtocol.expect(contentType);
                if (buffer.readableBytes() == 0) {
                    ReferenceCountUtil.release((Object)msg);
                    return;
                }
            }
        }
        ctx.fireChannelRead(msg);
    }

    private ContentType getContentType(byte messageCode) {
        for (ContentType contentType : ContentType.values()) {
            if (contentType.get() != messageCode) continue;
            return contentType;
        }
        throw new IllegalArgumentException("Illegal inbound. Could not find a ContentType with value " + messageCode);
    }
}

