/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.messaging.marshalling.v2.decoding;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.io.IOException;
import java.time.Clock;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import org.neo4j.causalclustering.catchup.Protocol;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.core.consensus.log.RaftLogEntry;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.causalclustering.identity.ClusterId;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.messaging.EndOfStreamException;
import org.neo4j.causalclustering.messaging.NetworkReadableClosableChannelNetty4;
import org.neo4j.causalclustering.messaging.marshalling.v2.ContentType;
import org.neo4j.storageengine.api.ReadableChannel;

public class RaftMessageDecoder
extends ByteToMessageDecoder {
    private final Protocol<ContentType> protocol;

    RaftMessageDecoder(Protocol<ContentType> protocol) {
        this.protocol = protocol;
    }

    public void decode(ChannelHandlerContext ctx, ByteBuf buffer, List<Object> list) throws Exception {
        LazyComposer composer;
        NetworkReadableClosableChannelNetty4 channel = new NetworkReadableClosableChannelNetty4(buffer);
        ClusterId clusterId = (ClusterId)ClusterId.Marshal.INSTANCE.unmarshal((ReadableChannel)channel);
        int messageTypeWire = channel.getInt();
        RaftMessages.Type[] values = RaftMessages.Type.values();
        RaftMessages.Type messageType = values[messageTypeWire];
        MemberId from = this.retrieveMember((ReadableChannel)channel);
        if (messageType.equals((Object)RaftMessages.Type.VOTE_REQUEST)) {
            MemberId candidate = this.retrieveMember((ReadableChannel)channel);
            long term = channel.getLong();
            long lastLogIndex = channel.getLong();
            long lastLogTerm = channel.getLong();
            composer = new SimpleMessageComposer(new RaftMessages.Vote.Request(from, term, candidate, lastLogIndex, lastLogTerm));
        } else if (messageType.equals((Object)RaftMessages.Type.VOTE_RESPONSE)) {
            long term = channel.getLong();
            boolean voteGranted = channel.get() == 1;
            composer = new SimpleMessageComposer(new RaftMessages.Vote.Response(from, term, voteGranted));
        } else if (messageType.equals((Object)RaftMessages.Type.PRE_VOTE_REQUEST)) {
            MemberId candidate = this.retrieveMember((ReadableChannel)channel);
            long term = channel.getLong();
            long lastLogIndex = channel.getLong();
            long lastLogTerm = channel.getLong();
            composer = new SimpleMessageComposer(new RaftMessages.PreVote.Request(from, term, candidate, lastLogIndex, lastLogTerm));
        } else if (messageType.equals((Object)RaftMessages.Type.PRE_VOTE_RESPONSE)) {
            long term = channel.getLong();
            boolean voteGranted = channel.get() == 1;
            composer = new SimpleMessageComposer(new RaftMessages.PreVote.Response(from, term, voteGranted));
        } else if (messageType.equals((Object)RaftMessages.Type.APPEND_ENTRIES_REQUEST)) {
            long term = channel.getLong();
            long prevLogIndex = channel.getLong();
            long prevLogTerm = channel.getLong();
            long leaderCommit = channel.getLong();
            int entryCount = channel.getInt();
            composer = new AppendEntriesComposer(entryCount, from, term, prevLogIndex, prevLogTerm, leaderCommit);
        } else if (messageType.equals((Object)RaftMessages.Type.APPEND_ENTRIES_RESPONSE)) {
            long term = channel.getLong();
            boolean success = channel.get() == 1;
            long matchIndex = channel.getLong();
            long appendIndex = channel.getLong();
            composer = new SimpleMessageComposer(new RaftMessages.AppendEntries.Response(from, term, success, matchIndex, appendIndex));
        } else if (messageType.equals((Object)RaftMessages.Type.NEW_ENTRY_REQUEST)) {
            composer = new NewEntryRequestComposer(from);
        } else if (messageType.equals((Object)RaftMessages.Type.HEARTBEAT)) {
            long leaderTerm = channel.getLong();
            long commitIndexTerm = channel.getLong();
            long commitIndex = channel.getLong();
            composer = new SimpleMessageComposer(new RaftMessages.Heartbeat(from, leaderTerm, commitIndex, commitIndexTerm));
        } else if (messageType.equals((Object)RaftMessages.Type.HEARTBEAT_RESPONSE)) {
            composer = new SimpleMessageComposer(new RaftMessages.HeartbeatResponse(from));
        } else if (messageType.equals((Object)RaftMessages.Type.LOG_COMPACTION_INFO)) {
            long leaderTerm = channel.getLong();
            long prevIndex = channel.getLong();
            composer = new SimpleMessageComposer(new RaftMessages.LogCompactionInfo(from, leaderTerm, prevIndex));
        } else {
            throw new IllegalArgumentException("Unknown message type");
        }
        list.add(new ClusterIdAwareMessageComposer(composer, clusterId));
        this.protocol.expect(ContentType.ContentType);
    }

    private MemberId retrieveMember(ReadableChannel buffer) throws IOException, EndOfStreamException {
        MemberId.Marshal memberIdMarshal = new MemberId.Marshal();
        return (MemberId)memberIdMarshal.unmarshal(buffer);
    }

    private static class NewEntryRequestComposer
    implements LazyComposer {
        private final MemberId from;

        NewEntryRequestComposer(MemberId from) {
            this.from = from;
        }

        @Override
        public Optional<RaftMessages.RaftMessage> maybeComplete(Queue<Long> terms, Queue<ReplicatedContent> contents) {
            if (contents.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(new RaftMessages.NewEntry.Request(this.from, contents.remove()));
        }
    }

    private static class AppendEntriesComposer
    implements LazyComposer {
        private final int entryCount;
        private final MemberId from;
        private final long term;
        private final long prevLogIndex;
        private final long prevLogTerm;
        private final long leaderCommit;

        AppendEntriesComposer(int entryCount, MemberId from, long term, long prevLogIndex, long prevLogTerm, long leaderCommit) {
            this.entryCount = entryCount;
            this.from = from;
            this.term = term;
            this.prevLogIndex = prevLogIndex;
            this.prevLogTerm = prevLogTerm;
            this.leaderCommit = leaderCommit;
        }

        @Override
        public Optional<RaftMessages.RaftMessage> maybeComplete(Queue<Long> terms, Queue<ReplicatedContent> contents) {
            if (terms.size() < this.entryCount || contents.size() < this.entryCount) {
                return Optional.empty();
            }
            RaftLogEntry[] entries = new RaftLogEntry[this.entryCount];
            for (int i = 0; i < this.entryCount; ++i) {
                long term = terms.remove();
                ReplicatedContent content = contents.remove();
                entries[i] = new RaftLogEntry(term, content);
            }
            return Optional.of(new RaftMessages.AppendEntries.Request(this.from, this.term, this.prevLogIndex, this.prevLogTerm, entries, this.leaderCommit));
        }
    }

    private static class SimpleMessageComposer
    implements LazyComposer {
        private final RaftMessages.RaftMessage message;

        private SimpleMessageComposer(RaftMessages.RaftMessage message) {
            this.message = message;
        }

        @Override
        public Optional<RaftMessages.RaftMessage> maybeComplete(Queue<Long> terms, Queue<ReplicatedContent> contents) {
            return Optional.of(this.message);
        }
    }

    static interface LazyComposer {
        public Optional<RaftMessages.RaftMessage> maybeComplete(Queue<Long> var1, Queue<ReplicatedContent> var2);
    }

    static class ClusterIdAwareMessageComposer {
        private final LazyComposer composer;
        private final ClusterId clusterId;

        ClusterIdAwareMessageComposer(LazyComposer composer, ClusterId clusterId) {
            this.composer = composer;
            this.clusterId = clusterId;
        }

        Optional<RaftMessages.ClusterIdAwareMessage> maybeCompose(Clock clock, Queue<Long> terms, Queue<ReplicatedContent> contents) {
            return this.composer.maybeComplete(terms, contents).map(m -> RaftMessages.ReceivedInstantClusterIdAwareMessage.of(clock.instant(), this.clusterId, m));
        }
    }
}

