/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.net;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.net.BindException;
import java.net.SocketAddress;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.neo4j.causalclustering.helper.SuspendableLifeCycle;
import org.neo4j.causalclustering.net.ChildInitializer;
import org.neo4j.helpers.ListenSocketAddress;
import org.neo4j.helpers.NamedThreadFactory;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class Server
extends SuspendableLifeCycle {
    private final Log debugLog;
    private final Log userLog;
    private final String serverName;
    private final NamedThreadFactory threadFactory;
    private final ChildInitializer childInitializer;
    private final ChannelInboundHandler parentHandler;
    private final ListenSocketAddress listenAddress;
    private EventLoopGroup workerGroup;
    private Channel channel;

    public Server(ChildInitializer childInitializer, LogProvider debugLogProvider, LogProvider userLogProvider, ListenSocketAddress listenAddress, String serverName) {
        this(childInitializer, null, debugLogProvider, userLogProvider, listenAddress, serverName);
    }

    public Server(ChildInitializer childInitializer, ChannelInboundHandler parentHandler, LogProvider debugLogProvider, LogProvider userLogProvider, ListenSocketAddress listenAddress, String serverName) {
        super(debugLogProvider.getLog(Server.class));
        this.childInitializer = childInitializer;
        this.parentHandler = parentHandler;
        this.listenAddress = listenAddress;
        this.debugLog = debugLogProvider.getLog(this.getClass());
        this.userLog = userLogProvider.getLog(this.getClass());
        this.serverName = serverName;
        this.threadFactory = new NamedThreadFactory(serverName);
    }

    public Server(ChildInitializer childInitializer, ListenSocketAddress listenAddress, String serverName) {
        this(childInitializer, null, (LogProvider)NullLogProvider.getInstance(), (LogProvider)NullLogProvider.getInstance(), listenAddress, serverName);
    }

    @Override
    protected void init0() {
    }

    @Override
    protected void start0() {
        if (this.channel != null) {
            return;
        }
        this.workerGroup = new NioEventLoopGroup(0, (ThreadFactory)this.threadFactory);
        ServerBootstrap bootstrap = ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(this.workerGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_REUSEADDR, (Object)Boolean.TRUE)).localAddress((SocketAddress)this.listenAddress.socketAddress())).childHandler(this.childInitializer.asChannelInitializer());
        if (this.parentHandler != null) {
            bootstrap.handler((ChannelHandler)this.parentHandler);
        }
        try {
            this.channel = bootstrap.bind().syncUninterruptibly().channel();
            this.debugLog.info(this.serverName + ": bound to " + this.listenAddress);
        }
        catch (Exception e) {
            if (e instanceof BindException) {
                String message = this.serverName + ": address is already bound: " + this.listenAddress;
                this.userLog.error(message);
                this.debugLog.error(message, (Throwable)e);
            }
            throw e;
        }
    }

    @Override
    protected void stop0() {
        if (this.channel == null) {
            return;
        }
        this.debugLog.info(this.serverName + ": stopping and unbinding from: " + this.listenAddress);
        try {
            this.channel.close().sync();
            this.channel = null;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.debugLog.warn("Interrupted while closing channel.");
        }
        if (this.workerGroup != null && this.workerGroup.shutdownGracefully(2L, 5L, TimeUnit.SECONDS).awaitUninterruptibly(10L, TimeUnit.SECONDS)) {
            this.debugLog.warn("Worker group not shutdown within 10 seconds.");
        }
        this.workerGroup = null;
    }

    @Override
    protected void shutdown0() {
    }

    public ListenSocketAddress address() {
        return this.listenAddress;
    }

    public String toString() {
        return String.format("Server[%s]", this.serverName);
    }
}

