/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.routing.multi_cluster.procedure;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.discovery.CoreServerInfo;
import org.neo4j.causalclustering.discovery.CoreTopology;
import org.neo4j.causalclustering.discovery.TopologyService;
import org.neo4j.causalclustering.routing.Endpoint;
import org.neo4j.causalclustering.routing.Util;
import org.neo4j.causalclustering.routing.multi_cluster.MultiClusterRoutingResult;
import org.neo4j.causalclustering.routing.multi_cluster.procedure.MultiClusterRoutingResultFormat;
import org.neo4j.causalclustering.routing.multi_cluster.procedure.ParameterNames;
import org.neo4j.causalclustering.routing.multi_cluster.procedure.ProcedureNames;
import org.neo4j.collection.RawIterator;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.kernel.api.ResourceTracker;
import org.neo4j.kernel.api.proc.CallableProcedure;
import org.neo4j.kernel.api.proc.Context;
import org.neo4j.kernel.configuration.Config;

public class GetRoutersForAllDatabasesProcedure
implements CallableProcedure {
    private static final String DESCRIPTION = "Returns router capable endpoints for each database name in a multi-cluster.";
    private final ProcedureSignature procedureSignature = ProcedureSignature.procedureSignature((String[])ProcedureNames.GET_ROUTERS_FOR_ALL_DATABASES.fullyQualifiedProcedureName()).out(ParameterNames.TTL.parameterName(), (Neo4jTypes.AnyType)Neo4jTypes.NTInteger).out(ParameterNames.ROUTERS.parameterName(), (Neo4jTypes.AnyType)Neo4jTypes.NTList((Neo4jTypes.AnyType)Neo4jTypes.NTMap)).description("Returns router capable endpoints for each database name in a multi-cluster.").build();
    private final TopologyService topologyService;
    private final long timeToLiveMillis;

    public GetRoutersForAllDatabasesProcedure(TopologyService topologyService, Config config) {
        this.topologyService = topologyService;
        this.timeToLiveMillis = ((Duration)config.get(CausalClusteringSettings.cluster_routing_ttl)).toMillis();
    }

    public ProcedureSignature signature() {
        return this.procedureSignature;
    }

    public RawIterator<Object[], ProcedureException> apply(Context ctx, Object[] input, ResourceTracker resourceTracker) throws ProcedureException {
        Map<String, List<Endpoint>> routersPerDb = this.routeEndpoints();
        MultiClusterRoutingResult result = new MultiClusterRoutingResult(routersPerDb, this.timeToLiveMillis);
        return RawIterator.of((Object[])new Object[][]{MultiClusterRoutingResultFormat.build(result)});
    }

    private Map<String, List<Endpoint>> routeEndpoints() {
        CoreTopology core = this.topologyService.allCoreServers();
        Stream<CoreServerInfo> allCoreMemberInfo = this.topologyService.allCoreServers().members().values().stream();
        Map<String, List<CoreServerInfo>> coresByDb = allCoreMemberInfo.collect(Collectors.groupingBy(CoreServerInfo::getDatabaseName));
        Function<Map.Entry, List> extractQualifiedBoltAddresses = entry -> {
            List cores = (List)entry.getValue();
            return cores.stream().map(Util.extractBoltAddress()).map(Endpoint::route).collect(Collectors.toList());
        };
        return coresByDb.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, extractQualifiedBoltAddresses));
    }
}

