/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.upstream.strategies;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.upstream.UpstreamDatabaseSelectionStrategy;
import org.neo4j.function.Predicates;

public class TypicallyConnectToRandomReadReplicaStrategy
extends UpstreamDatabaseSelectionStrategy {
    public static final String IDENTITY = "typically-connect-to-random-read-replica";
    private final ModuloCounter counter;

    public TypicallyConnectToRandomReadReplicaStrategy() {
        this(10);
    }

    public TypicallyConnectToRandomReadReplicaStrategy(int connectToCoreInterval) {
        super(IDENTITY, new String[0]);
        this.counter = new ModuloCounter(connectToCoreInterval);
    }

    @Override
    public Optional<MemberId> upstreamDatabase() {
        if (this.counter.shouldReturnCoreMemberId()) {
            return this.randomCoreMember();
        }
        ArrayList<MemberId> readReplicaMembers = new ArrayList<MemberId>(this.topologyService.localReadReplicas().members().keySet());
        Collections.shuffle(readReplicaMembers);
        ArrayList<MemberId> coreMembers = new ArrayList<MemberId>(this.topologyService.localCoreServers().members().keySet());
        Collections.shuffle(coreMembers);
        return Stream.concat(readReplicaMembers.stream(), coreMembers.stream()).filter(Predicates.not(this.myself::equals)).findFirst();
    }

    private Optional<MemberId> randomCoreMember() {
        List coreMembersNotSelf = this.topologyService.localCoreServers().members().keySet().stream().filter(Predicates.not(this.myself::equals)).collect(Collectors.toList());
        Collections.shuffle(coreMembersNotSelf);
        if (coreMembersNotSelf.size() == 0) {
            return Optional.empty();
        }
        return Optional.of(coreMembersNotSelf.get(0));
    }

    private static class ModuloCounter {
        private final int modulo;
        private int counter;

        ModuloCounter(int modulo) {
            this.modulo = modulo;
        }

        boolean shouldReturnCoreMemberId() {
            this.counter = (this.counter + 1) % this.modulo;
            return this.counter == 0;
        }
    }
}

