/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.helpers.collection;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.neo4j.util.VisibleForTesting;

public class LruCache<K, E> {
    private final String name;
    private final int maxSize;
    private final Map<K, E> cache = new LinkedHashMap<K, E>(500, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, E> eldest) {
            if (super.size() > LruCache.this.maxSize) {
                LruCache.this.elementCleaned(eldest.getValue());
                return true;
            }
            return false;
        }
    };

    public LruCache(String name, int maxSize) {
        if (name == null || maxSize < 1) {
            throw new IllegalArgumentException("maxSize=" + maxSize + ", name=" + name);
        }
        this.name = name;
        this.maxSize = maxSize;
    }

    public String getName() {
        return this.name;
    }

    public int maxSize() {
        return this.maxSize;
    }

    public synchronized void put(K key, E element) {
        if (key == null || element == null) {
            throw new IllegalArgumentException("key=" + String.valueOf(key) + ", element=" + String.valueOf(element));
        }
        this.cache.put(key, element);
    }

    public synchronized E remove(K key) {
        if (key == null) {
            throw new IllegalArgumentException("Null parameter");
        }
        return this.cache.remove(key);
    }

    public synchronized E get(K key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        return this.cache.get(key);
    }

    public synchronized void clear() {
        for (Map.Entry<K, E> keEntry : this.cache.entrySet()) {
            this.elementCleaned(keEntry.getValue());
        }
        this.cache.clear();
    }

    public synchronized int size() {
        return this.cache.size();
    }

    public synchronized Set<K> keySet() {
        return this.cache.keySet();
    }

    @VisibleForTesting
    protected void elementCleaned(E element) {
    }
}

