/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration.helpers;

import java.util.List;
import java.util.Objects;
import org.neo4j.configuration.helpers.SocketAddress;

public class RemoteUri {
    private final String scheme;
    private final List<SocketAddress> addresses;
    private final String query;

    public RemoteUri(String scheme, List<SocketAddress> addresses, String query) {
        this.scheme = scheme;
        this.addresses = addresses;
        this.query = query;
    }

    public String getScheme() {
        return this.scheme;
    }

    public List<SocketAddress> getAddresses() {
        return this.addresses;
    }

    public String getQuery() {
        return this.query;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteUri remoteUri = (RemoteUri)o;
        return Objects.equals(this.scheme, remoteUri.scheme) && Objects.equals(this.addresses, remoteUri.addresses) && Objects.equals(this.query, remoteUri.query);
    }

    public int hashCode() {
        return Objects.hash(this.scheme, this.addresses, this.query);
    }

    public String toString() {
        return "RemoteUri{scheme='" + this.scheme + "', addresses=" + String.valueOf(this.addresses) + ", query='" + this.query + "'}";
    }
}

