/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.impl.index.DroppableIndex;
import org.neo4j.kernel.api.impl.index.DroppableLuceneIndex;
import org.neo4j.kernel.api.impl.index.IndexWriterConfigs;
import org.neo4j.kernel.api.impl.index.LuceneMinimalIndexAccessor;
import org.neo4j.kernel.api.impl.index.partition.ReadOnlyIndexPartitionFactory;
import org.neo4j.kernel.api.impl.index.storage.DirectoryFactory;
import org.neo4j.kernel.api.impl.index.storage.IndexStorageFactory;
import org.neo4j.kernel.api.impl.index.storage.PartitionedIndexStorage;
import org.neo4j.kernel.api.impl.schema.LuceneIndexAccessor;
import org.neo4j.kernel.api.impl.schema.LuceneSchemaIndexBuilder;
import org.neo4j.kernel.api.impl.schema.SchemaIndex;
import org.neo4j.kernel.api.impl.schema.populator.NonUniqueLuceneIndexPopulator;
import org.neo4j.kernel.api.impl.schema.populator.UniqueLuceneIndexPopulator;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.MinimalIndexAccessor;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.IndexUpdateIgnoreStrategy;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.Monitors;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.migration.SchemaIndexMigrator;
import org.neo4j.storageengine.migration.StoreMigrationParticipant;
import org.neo4j.util.VisibleForTesting;
import org.neo4j.values.storable.ValueCategory;

public abstract class AbstractLuceneIndexProvider
extends IndexProvider {
    public static final IndexUpdateIgnoreStrategy UPDATE_IGNORE_STRATEGY = values -> values[0].valueGroup().category() != ValueCategory.TEXT;
    private final IndexStorageFactory indexStorageFactory;
    private final Config config;
    private final DatabaseReadOnlyChecker readOnlyChecker;
    private final FileSystemAbstraction fileSystem;
    private final IndexProvider.Monitor monitor;
    private final IndexType supportedIndexType;

    public AbstractLuceneIndexProvider(IndexType supportedIndexType, IndexProviderDescriptor descriptor, FileSystemAbstraction fileSystem, DirectoryFactory directoryFactory, IndexDirectoryStructure.Factory directoryStructureFactory, Monitors monitors, Config config, DatabaseReadOnlyChecker readOnlyChecker) {
        super(descriptor, directoryStructureFactory);
        this.supportedIndexType = supportedIndexType;
        this.monitor = (IndexProvider.Monitor)monitors.newMonitor(IndexProvider.Monitor.class, new String[]{descriptor.toString()});
        this.indexStorageFactory = this.buildIndexStorageFactory(fileSystem, directoryFactory);
        this.fileSystem = fileSystem;
        this.config = config;
        this.readOnlyChecker = readOnlyChecker;
    }

    @VisibleForTesting
    protected IndexStorageFactory buildIndexStorageFactory(FileSystemAbstraction fileSystem, DirectoryFactory directoryFactory) {
        return new IndexStorageFactory(directoryFactory, fileSystem, this.directoryStructure());
    }

    public void validatePrototype(IndexPrototype prototype) {
        IndexType indexType = prototype.getIndexType();
        if (indexType != this.supportedIndexType) {
            String providerName = this.getProviderDescriptor().name();
            throw new IllegalArgumentException("The '" + providerName + "' index provider does not support " + String.valueOf(indexType) + " indexes: " + String.valueOf(prototype));
        }
    }

    public MinimalIndexAccessor getMinimalIndexAccessor(IndexDescriptor descriptor) {
        PartitionedIndexStorage indexStorage = this.indexStorageFactory.indexStorageOf(descriptor.getId());
        DroppableIndex index = new DroppableIndex(new DroppableLuceneIndex(indexStorage, new ReadOnlyIndexPartitionFactory(), descriptor));
        return new LuceneMinimalIndexAccessor(descriptor, index, true);
    }

    public IndexPopulator getPopulator(IndexDescriptor descriptor, IndexSamplingConfig samplingConfig, ByteBufferFactory bufferFactory, MemoryTracker memoryTracker, TokenNameLookup tokenNameLookup) {
        SchemaIndex luceneIndex = ((LuceneSchemaIndexBuilder)((LuceneSchemaIndexBuilder)LuceneSchemaIndexBuilder.create(descriptor, this.readOnlyChecker, this.config).withFileSystem(this.fileSystem)).withSamplingConfig(samplingConfig).withIndexStorage(this.getIndexStorage(descriptor.getId()))).withWriterConfig(() -> IndexWriterConfigs.population(this.config)).build();
        if (luceneIndex.isReadOnly()) {
            throw new UnsupportedOperationException("Can't create populator for read only index");
        }
        return descriptor.isUnique() ? new UniqueLuceneIndexPopulator(luceneIndex, descriptor, UPDATE_IGNORE_STRATEGY) : new NonUniqueLuceneIndexPopulator(luceneIndex, UPDATE_IGNORE_STRATEGY);
    }

    public IndexAccessor getOnlineAccessor(IndexDescriptor descriptor, IndexSamplingConfig samplingConfig, TokenNameLookup tokenNameLookup) throws IOException {
        SchemaIndex luceneIndex = ((LuceneSchemaIndexBuilder)LuceneSchemaIndexBuilder.create(descriptor, this.readOnlyChecker, this.config).withSamplingConfig(samplingConfig).withIndexStorage(this.getIndexStorage(descriptor.getId()))).build();
        luceneIndex.open();
        return new LuceneIndexAccessor(luceneIndex, descriptor, tokenNameLookup, UPDATE_IGNORE_STRATEGY);
    }

    public InternalIndexState getInitialState(IndexDescriptor descriptor, CursorContext cursorContext) {
        PartitionedIndexStorage indexStorage = this.getIndexStorage(descriptor.getId());
        String failure = indexStorage.getStoredIndexFailure();
        if (failure != null) {
            return InternalIndexState.FAILED;
        }
        try {
            return this.indexIsOnline(indexStorage, descriptor) ? InternalIndexState.ONLINE : InternalIndexState.POPULATING;
        }
        catch (IOException e) {
            this.monitor.failedToOpenIndex(descriptor, "Requesting re-population.", (Exception)e);
            return InternalIndexState.POPULATING;
        }
    }

    public StoreMigrationParticipant storeMigrationParticipant(FileSystemAbstraction fs, PageCache pageCache, StorageEngineFactory storageEngineFactory) {
        return new SchemaIndexMigrator(this.getProviderDescriptor().name(), fs, pageCache, this.directoryStructure(), storageEngineFactory, true);
    }

    public String getPopulationFailure(IndexDescriptor descriptor, CursorContext cursorContext) throws IllegalStateException {
        return (String)StringUtils.defaultIfEmpty((CharSequence)this.getIndexStorage(descriptor.getId()).getStoredIndexFailure(), (CharSequence)"");
    }

    private PartitionedIndexStorage getIndexStorage(long indexId) {
        return this.indexStorageFactory.indexStorageOf(indexId);
    }

    private boolean indexIsOnline(PartitionedIndexStorage indexStorage, IndexDescriptor descriptor) throws IOException {
        try (SchemaIndex index = ((LuceneSchemaIndexBuilder)LuceneSchemaIndexBuilder.create(descriptor, this.readOnlyChecker, this.config).withIndexStorage(indexStorage)).build();){
            if (index.exists()) {
                index.open();
                boolean bl = index.isOnline();
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public IndexDescriptor completeConfiguration(IndexDescriptor index) {
        return index;
    }
}

