/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.activity;

import java.util.HashMap;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.nuxeo.ecm.activity.ActivityHelper;
import org.nuxeo.ecm.activity.ActivityLinkBuilder;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.impl.DocumentLocationImpl;
import org.nuxeo.ecm.core.io.download.DownloadService;
import org.nuxeo.ecm.platform.ui.web.rest.api.URLPolicyService;
import org.nuxeo.ecm.platform.url.DocumentViewImpl;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.nuxeo.ecm.user.center.profile.UserProfileService;
import org.nuxeo.runtime.api.Framework;

public class DefaultActivityLinkBuilder
implements ActivityLinkBuilder {
    @Override
    public String getDocumentLink(String documentActivityObject, String displayValue) {
        documentActivityObject = StringEscapeUtils.escapeHtml4((String)documentActivityObject);
        displayValue = StringEscapeUtils.escapeHtml4((String)displayValue);
        String link = "<a href=\"%s\" target=\"_top\">%s</a>";
        return String.format(link, this.getDocumentURL(ActivityHelper.getRepositoryName(documentActivityObject), ActivityHelper.getDocumentId(documentActivityObject)), displayValue);
    }

    protected String getDocumentURL(String repositoryName, String documentId) {
        DocumentLocationImpl docLoc = new DocumentLocationImpl(repositoryName, (DocumentRef)new IdRef(documentId));
        DocumentViewImpl docView = new DocumentViewImpl((DocumentLocation)docLoc, "view_documents");
        URLPolicyService urlPolicyService = (URLPolicyService)Framework.getService(URLPolicyService.class);
        return urlPolicyService.getUrlFromDocumentView("id", (DocumentView)docView, VirtualHostHelper.getContextPathProperty());
    }

    @Override
    public String getUserProfileLink(String userActivityObject, String displayValue) {
        userActivityObject = StringEscapeUtils.escapeHtml4((String)userActivityObject);
        displayValue = StringEscapeUtils.escapeHtml4((String)displayValue);
        String link = "<span class=\"username\"><a href=\"%s\" target=\"_top\" title=\"%s\">%s</a></span>";
        String username = ActivityHelper.getUsername(userActivityObject);
        return String.format(link, this.getUserProfileURL(username), username, displayValue);
    }

    protected String getUserProfileURL(String username) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("username", username);
        DocumentViewImpl docView = new DocumentViewImpl(null, null, params);
        URLPolicyService urlPolicyService = (URLPolicyService)Framework.getService(URLPolicyService.class);
        if (urlPolicyService == null) {
            return "";
        }
        return urlPolicyService.getUrlFromDocumentView("user", (DocumentView)docView, VirtualHostHelper.getContextPathProperty());
    }

    @Override
    public String getUserAvatarURL(CoreSession session, String username) {
        UserProfileService userProfileService = (UserProfileService)Framework.getService(UserProfileService.class);
        DocumentModel profile = userProfileService.getUserProfileDocument(username, session);
        Blob avatar = (Blob)profile.getPropertyValue("userprofile:avatar");
        if (avatar != null) {
            DownloadService downloadService = (DownloadService)Framework.getService(DownloadService.class);
            String filename = username + "." + FilenameUtils.getExtension((String)avatar.getFilename());
            return VirtualHostHelper.getContextPathProperty() + "/" + downloadService.getDownloadUrl(profile, "userprofile:avatar", filename);
        }
        return VirtualHostHelper.getContextPathProperty() + "/icons/missing_avatar.png";
    }
}

