/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.activity;

import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.activity.Activity;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;

public class ActivityHelper {
    public static final String SEPARATOR = ":";
    public static final String USER_PREFIX = "user:";
    public static final String DOC_PREFIX = "doc:";
    public static final String ACTIVITY_PREFIX = "activity:";

    private ActivityHelper() {
    }

    public static boolean isUser(String activityObject) {
        return activityObject != null && activityObject.startsWith(USER_PREFIX);
    }

    public static boolean isDocument(String activityObject) {
        return activityObject != null && activityObject.startsWith(DOC_PREFIX);
    }

    public static boolean isActivity(String activityObject) {
        return activityObject != null && activityObject.startsWith(ACTIVITY_PREFIX);
    }

    public static String getUsername(String activityObject) {
        if (!ActivityHelper.isUser(activityObject)) {
            throw new IllegalArgumentException(activityObject + " is not a user activity object");
        }
        return activityObject.replaceAll(USER_PREFIX, "");
    }

    public static List<String> getUsernames(List<String> activityObjects) {
        ArrayList<String> usernames = new ArrayList<String>();
        for (String activityObject : activityObjects) {
            usernames.add(ActivityHelper.getUsername(activityObject));
        }
        return usernames;
    }

    public static String getDocumentId(String activityObject) {
        if (ActivityHelper.isDocument(activityObject)) {
            String[] v = activityObject.split(SEPARATOR);
            return v[2];
        }
        return "";
    }

    public static String getRepositoryName(String activityObject) {
        if (ActivityHelper.isDocument(activityObject)) {
            String[] v = activityObject.split(SEPARATOR);
            return v[1];
        }
        return "";
    }

    public static String getActivityId(String activityObject) {
        if (ActivityHelper.isActivity(activityObject)) {
            String[] v = activityObject.split(SEPARATOR);
            return v[1];
        }
        return "";
    }

    public static String createDocumentActivityObject(DocumentModel doc) {
        return ActivityHelper.createDocumentActivityObject(doc.getRepositoryName(), doc.getId());
    }

    public static String createDocumentActivityObject(String repositoryName, String docId) {
        return DOC_PREFIX + repositoryName + SEPARATOR + docId;
    }

    public static String createUserActivityObject(Principal principal) {
        return ActivityHelper.createUserActivityObject(principal.getName());
    }

    public static String createUserActivityObject(String username) {
        return USER_PREFIX + username;
    }

    public static String createActivityObject(Activity activity) {
        return ActivityHelper.createActivityObject(activity.getId());
    }

    public static String createActivityObject(Serializable activityId) {
        return ACTIVITY_PREFIX + activityId;
    }

    public static String generateDisplayName(Principal principal) {
        NuxeoPrincipal nuxeoPrincipal;
        if (!(!(principal instanceof NuxeoPrincipal) || StringUtils.isBlank((String)(nuxeoPrincipal = (NuxeoPrincipal)principal).getFirstName()) && StringUtils.isBlank((String)nuxeoPrincipal.getLastName()))) {
            return nuxeoPrincipal.getFirstName() + " " + nuxeoPrincipal.getLastName();
        }
        return principal.getName();
    }

    public static String getDocumentTitle(DocumentModel doc) {
        try {
            return doc.getTitle();
        }
        catch (ClientException e) {
            return doc.getId();
        }
    }
}

