/*
 * (C) Copyright 2006-2010 Nuxeo SAS (http://nuxeo.com/) and contributors.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser General Public License
 * (LGPL) version 2.1 which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl.html
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * Contributors:
 *     bstefanescu
 */
package org.nuxeo.connect.update.impl.xml;

import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.connect.update.PackageDependency;
import org.nuxeo.connect.update.PackageType;
import org.nuxeo.connect.update.Validator;
import org.nuxeo.connect.update.Version;
import org.nuxeo.connect.update.task.Task;

/**
 * @author <a href="mailto:bs@nuxeo.com">Bogdan Stefanescu</a>
 * 
 */
@XObject("package")
public class PackageDefinition {

    @XNode("@name")
    public String name;

    @XNode("@version")
    public Version version;

    @XNode("@type")
    public PackageType type;

    @XNode("title")
    public String title;

    @XNode("description")
    public String description;

    @XNode("classifier")
    public String classifier;

    @XNode("vendor")
    public String vendor;

    @XNode("home-page")
    public String homePage;

    @XNodeList(value = "platforms/platform", type = String[].class, componentType = String.class)
    public String[] platforms;

    /**
     * The dependency value format is:
     * <code>package_name[:package_min_version[:package_max_version]]</code> if
     * no min and max version are specified the the last version should be used.
     */
    @XNodeList(value = "dependencies/package", type = PackageDependency[].class, componentType = PackageDependency.class)
    public PackageDependency[] dependencies;

    /**
     * A class implementing {@link Task}. if not specified the default
     * implementation will be used
     */
    @XNode("installer")
    public TaskDefinition installer;

    /**
     * A class implementing {@link Task}. if not specified the default
     * implementation will be used
     */
    @XNode("uninstaller")
    public TaskDefinition uninstaller;

    /**
     * A class implementing {@link Validator}. If not specified not post install
     * validation will be done
     */
    @XNode("validator")
    public String validator;

    public String getId() {
        if (version == null) {
            return name;
        } else {
            return name + "-" + version.toString();
        }
    }

}
