/*
 * (C) Copyright 2006-2010 Nuxeo SAS (http://nuxeo.com/) and contributors.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser General Public License
 * (LGPL) version 2.1 which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl.html
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * Contributors:
 *     bstefanescu
 */
package org.nuxeo.connect.update.impl.xml;

import org.nuxeo.connect.update.PackageDependency;

/**
 * @author <a href="mailto:bs@nuxeo.com">Bogdan Stefanescu</a>
 * 
 */
public class XmlSerializer extends XmlWriter {

    public XmlSerializer() {
        super();
    }

    public XmlSerializer(String tab) {
        super(tab);
    }

    public String toXML(PackageDefinition def) {
        start("package");
        if (def.type != null) {
            attr("type", def.type.getValue());
        }
        attr("name", def.name);
        if (def.version != null) {
            attr("version", def.version.toString());
        }
        startContent();

        element("title", def.title);
        element("description", def.description);
        element("vendor", def.vendor);
        element("classifier", def.classifier);
        element("home-page", def.homePage);

        if (def.installer != null) {
            start("installer");
            attr("class", def.installer.type);
            attr("restart", String.valueOf(def.installer.restart));
            end();
        }
        if (def.uninstaller != null) {
            start("uninstaller");
            attr("class", def.uninstaller.type);
            attr("restart", String.valueOf(def.uninstaller.restart));
            end();
        }
        element("validator", def.validator);

        if (def.platforms != null && def.platforms.length > 0) {
            start("platforms");
            startContent();
            for (String platform : def.platforms) {
                element("platform", platform);
            }
            end("platforms");
        }

        if (def.dependencies != null && def.dependencies.length > 0) {
            start("dependencies");
            startContent();
            for (PackageDependency dep : def.dependencies) {
                element("package", dep.toString());
            }
            end("dependencies");
        }

        end("package");
        return sb.toString();
    }

    public void buildXML(FormDefinition form) {
        start("form");
        startContent();
        element("title", form.title);
        element("image", form.image);
        element("description", form.description);
        if (form.fields != null && form.fields.length > 0) {
            start("fields");
            startContent();
            for (FieldDefinition field : form.fields) {
                start("field");
                attr("name", field.name);
                attr("type", field.type);
                if (field.isRequired) {
                    attr("required", "true");
                }
                if (field.isReadOnly) {
                    attr("readonly", "true");
                }
                if (field.isVertical) {
                    attr("vertical", "true");
                }
                startContent();
                element("label", field.label);
                element("value", field.value);
                end("field");
            }
            end("fields");
        }
        end("form");
    }

    public String toXML(FormDefinition form) {
        buildXML(form);
        return sb.toString();
    }

    public String toXML(FormDefinition... forms) {
        start("forms");
        startContent();
        for (FormDefinition form : forms) {
            buildXML(form);
        }
        end("forms");
        return sb.toString();
    }

    public String toXML(FormsDefinition forms) {
        start("forms");
        startContent();
        for (FormDefinition form : forms.forms) {
            buildXML(form);
        }
        end("forms");
        return sb.toString();
    }
}
