/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ai.bulk;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ai.cloud.CloudClient;
import org.nuxeo.ai.model.export.DatasetExportService;
import org.nuxeo.ecm.core.api.CloseableCoreSession;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.bulk.BulkCodecs;
import org.nuxeo.ecm.core.bulk.BulkService;
import org.nuxeo.ecm.core.bulk.message.BulkCommand;
import org.nuxeo.ecm.core.bulk.message.BulkStatus;
import org.nuxeo.lib.stream.computation.AbstractComputation;
import org.nuxeo.lib.stream.computation.ComputationContext;
import org.nuxeo.lib.stream.computation.Record;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class DataSetUploadComputation
extends AbstractComputation {
    private static final Log log = LogFactory.getLog(DataSetUploadComputation.class);

    public DataSetUploadComputation(String name) {
        super(name, 1, 0);
    }

    public void processRecord(ComputationContext context, String inputStreamName, Record record) {
        BulkStatus status = (BulkStatus)BulkCodecs.getStatusCodec().decode(record.getData());
        if ("bulkDatasetExport".equals(status.getAction()) && BulkStatus.State.COMPLETED.equals((Object)status.getState())) {
            BulkCommand cmd = ((BulkService)Framework.getService(BulkService.class)).getCommand(status.getCommandId());
            if (cmd != null) {
                TransactionHelper.runInTransaction(() -> {
                    try (CloseableCoreSession session = CoreInstance.openCoreSession((String)cmd.getRepository(), (String)cmd.getUsername());){
                        DocumentModel document = ((DatasetExportService)Framework.getService(DatasetExportService.class)).getCorpusDocument((CoreSession)session, cmd.getId());
                        if (document != null) {
                            CloudClient client = (CloudClient)Framework.getService(CloudClient.class);
                            if (client.isAvailable()) {
                                client.uploadDataset(document);
                            } else {
                                log.warn((Object)String.format("Upload to cloud not possible for doc %s and client %s", document.getId(), client.isAvailable()));
                            }
                        }
                    }
                });
            } else {
                log.warn((Object)String.format("The bulk command with id %s is missing.  Unable to upload a dataset.", status.getCommandId()));
            }
        }
        context.askForCheckpoint();
    }
}

