/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ai.bulk;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ai.bulk.DataSetExportStatusComputation;
import org.nuxeo.ai.bulk.RecordWriter;
import org.nuxeo.ai.services.AIComponent;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.lib.stream.computation.AbstractBatchComputation;
import org.nuxeo.lib.stream.computation.ComputationContext;
import org.nuxeo.lib.stream.computation.Record;
import org.nuxeo.runtime.api.Framework;

public class RecordWriterBatchComputation
extends AbstractBatchComputation {
    private static final Log log = LogFactory.getLog(RecordWriterBatchComputation.class);

    public RecordWriterBatchComputation(String name) {
        super(name, 1, 1);
    }

    public void batchProcess(ComputationContext context, String inputStream, List<Record> records) {
        Map recordsByCommand = records.stream().collect(Collectors.groupingBy(Record::getKey, Collectors.toList()));
        RecordWriter writer = ((AIComponent)Framework.getService(AIComponent.class)).getRecordWriter(this.metadata.name());
        if (writer == null) {
            throw new NuxeoException("Unknown record write specified: " + this.metadata.name());
        }
        recordsByCommand.forEach((commandId, recordsOfCommand) -> {
            try {
                writer.write(recordsOfCommand);
            }
            catch (IOException e) {
                throw new NuxeoException(String.format("Failed to write the %s batch for %s.", this.metadata.name(), commandId), (Throwable)e);
            }
        });
        recordsByCommand.forEach((commandId, recordsOfCommand) -> DataSetExportStatusComputation.updateExportStatusProcessed(context, commandId, recordsOfCommand.size()));
    }

    public void batchFailure(ComputationContext context, String inputStream, List<Record> records) {
        log.warn((Object)String.format("Batch failure \"%s\" batch of %s records with command ids: %s.", this.metadata.name(), records.size(), Arrays.toString(records.stream().map(Record::getKey).toArray())));
    }
}

