/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ai.model.export;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ai.model.export.DatasetExportService;
import org.nuxeo.ai.model.export.DatasetStatsService;
import org.nuxeo.ai.model.export.Statistic;
import org.nuxeo.ai.pipes.functions.PropertyUtils;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.bulk.BulkService;
import org.nuxeo.ecm.core.bulk.message.BulkCommand;
import org.nuxeo.ecm.platform.query.api.AggregateDefinition;
import org.nuxeo.ecm.platform.query.core.AggregateDescriptor;
import org.nuxeo.elasticsearch.aggregate.AggregateEsBase;
import org.nuxeo.elasticsearch.aggregate.AggregateFactory;
import org.nuxeo.elasticsearch.api.ElasticSearchService;
import org.nuxeo.elasticsearch.api.EsResult;
import org.nuxeo.elasticsearch.query.NxQueryBuilder;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.DefaultComponent;

public class DatasetExportServiceImpl
extends DefaultComponent
implements DatasetExportService,
DatasetStatsService {
    public static final PathRef PARENT_PATH = new PathRef("/AI_Corpus");
    public static final String NUXEO_FOLDER = "Folder";
    public static final String STATS_TOTAL = "total";
    public static final String STATS_COUNT = "count";
    public static final String DEFAULT_NUM_BUCKETS = "20";
    protected static final Properties EMPTY_PROPS = new Properties();
    private static final Log log = LogFactory.getLog(DatasetExportServiceImpl.class);

    protected static AggregateEsBase makeAggregate(String type, String field, Properties properties) {
        AggregateDescriptor descriptor = new AggregateDescriptor();
        descriptor.setId(DatasetExportServiceImpl.aggKey(field, type));
        descriptor.setDocumentField(field);
        descriptor.setType(type);
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> descriptor.setProperty((String)key, (String)value)));
        return AggregateFactory.create((AggregateDefinition)descriptor, null);
    }

    protected static String aggKey(String propName, String s) {
        return s + "_" + propName;
    }

    @Override
    public String export(CoreSession session, String nxql, Collection<String> inputProperties, Collection<String> outputProperties, int split) {
        this.validateParams(nxql, inputProperties, outputProperties);
        if (split < 1 || split > 100) {
            throw new IllegalArgumentException("Dataset split value is a percentage between 1 and 100");
        }
        List inputs = PropertyUtils.propsToTypedList(inputProperties);
        List outputs = PropertyUtils.propsToTypedList(outputProperties);
        ArrayList<Map<String, String>> featuresWithType = new ArrayList<Map<String, String>>(inputs);
        featuresWithType.addAll(outputs);
        DocumentModel corpus = this.createCorpus(session, nxql, inputs, outputs, split);
        ArrayList<String> featuresList = new ArrayList<String>(inputProperties);
        featuresList.addAll(outputProperties);
        BulkCommand bulkCommand = new BulkCommand.Builder("bulkDatasetExport", this.notNullNxql(nxql, featuresWithType)).repository(session.getRepositoryName()).user(session.getPrincipal().getName()).param("features", (Serializable)((Object)String.join((CharSequence)",", featuresList))).param("split", (Serializable)((Object)String.valueOf(split))).build();
        String bulkId = ((BulkService)Framework.getService(BulkService.class)).submit(bulkCommand);
        corpus.setPropertyValue("ai_corpus:job_id", (Serializable)((Object)bulkId));
        session.saveDocument(corpus);
        return bulkId;
    }

    protected void validateParams(String nxql, Collection<String> inputProperties, Collection<String> outputProperties) {
        if (StringUtils.isBlank((CharSequence)nxql) || inputProperties == null || inputProperties.isEmpty() || outputProperties == null || outputProperties.isEmpty()) {
            throw new IllegalArgumentException("nxql and properties are required parameters");
        }
        if (!nxql.toUpperCase().contains("WHERE")) {
            throw new IllegalArgumentException("You cannot use an unbounded nxql query, please add a WHERE clause.");
        }
    }

    public DocumentModel createCorpus(CoreSession session, String query, List<Map<String, String>> inputs, List<Map<String, String>> outputs, int split) {
        DocumentModel doc = session.createDocumentModel(this.getRootFolder(session), "corpor1", "AI_Corpus");
        doc.setPropertyValue("ai_corpus:query", (Serializable)((Object)query));
        doc.setPropertyValue("ai_corpus:split", (Serializable)Integer.valueOf(split));
        doc.setPropertyValue("ai_corpus:inputs", (Serializable)((Object)inputs));
        doc.setPropertyValue("ai_corpus:outputs", (Serializable)((Object)outputs));
        return session.createDocument(doc);
    }

    @Override
    public DocumentModel getCorpusDocument(CoreSession session, String id) {
        DocumentModelList docs = session.query(String.format("SELECT * FROM %s WHERE %s = '%s'", "AI_Corpus", "ai_corpus:job_id", id));
        if (docs.size() == 1) {
            return (DocumentModel)docs.get(0);
        }
        log.warn((Object)String.format("Corpus document error, there should only be 1 document for %s", id));
        return null;
    }

    protected String getRootFolder(CoreSession session) {
        if (!session.exists((DocumentRef)PARENT_PATH)) {
            DocumentModel doc = session.createDocumentModel("/", "AI_Corpus", NUXEO_FOLDER);
            doc.addFacet("HiddenInNavigation");
            session.createDocument(doc);
        }
        return PARENT_PATH.toString();
    }

    @Override
    public Collection<Statistic> getStatistics(CoreSession session, String nxql, Collection<String> inputProperties, Collection<String> outputProperties) {
        this.validateParams(nxql, inputProperties, outputProperties);
        ArrayList<String> featuresList = new ArrayList<String>(inputProperties);
        featuresList.addAll(outputProperties);
        List featuresWithType = PropertyUtils.propsToTypedList(featuresList);
        ArrayList<Statistic> stats = new ArrayList<Statistic>();
        NxQueryBuilder qb = new NxQueryBuilder(session).nxql(nxql).limit(0);
        Long total = this.getOverallStats(featuresWithType, stats, qb);
        if (total < 1L) {
            return Collections.emptyList();
        }
        qb = new NxQueryBuilder(session).nxql(this.notNullNxql(nxql, featuresWithType)).limit(0);
        this.getValidStats(featuresWithType, total, stats, qb);
        return stats;
    }

    protected void getValidStats(List<Map<String, String>> featuresWithType, long total, List<Statistic> stats, NxQueryBuilder qb) {
        block6: for (Map<String, String> prop : featuresWithType) {
            String propName = prop.get("name");
            switch (prop.get("type")) {
                case "img": {
                    continue block6;
                }
            }
            Properties termProps = new Properties();
            termProps.setProperty("size", DEFAULT_NUM_BUCKETS);
            qb.addAggregate(DatasetExportServiceImpl.makeAggregate("terms", propName, termProps));
            qb.addAggregate(DatasetExportServiceImpl.makeAggregate("cardinality", propName, EMPTY_PROPS));
        }
        EsResult esResult = ((ElasticSearchService)Framework.getService(ElasticSearchService.class)).queryAndAggregate(qb);
        stats.addAll(esResult.getAggregates().stream().map(Statistic::from).collect(Collectors.toList()));
        stats.add(Statistic.of(STATS_COUNT, STATS_COUNT, STATS_COUNT, null, esResult.getElasticsearchResponse().getHits().getTotalHits()));
    }

    protected Long getOverallStats(List<Map<String, String>> featuresWithType, List<Statistic> stats, NxQueryBuilder qb) {
        for (Map<String, String> prop : featuresWithType) {
            String propName = prop.get("name");
            switch (prop.get("type")) {
                case "txt": {
                    qb.addAggregate(DatasetExportServiceImpl.makeAggregate("missing", propName, EMPTY_PROPS));
                    break;
                }
                case "img": {
                    qb.addAggregate(DatasetExportServiceImpl.makeAggregate("missing", this.contentProperty(propName), EMPTY_PROPS));
                    break;
                }
            }
        }
        EsResult esResult = ((ElasticSearchService)Framework.getService(ElasticSearchService.class)).queryAndAggregate(qb);
        stats.addAll(esResult.getAggregates().stream().map(Statistic::from).collect(Collectors.toList()));
        Long total = esResult.getElasticsearchResponse().getHits().getTotalHits();
        stats.add(Statistic.of(STATS_TOTAL, STATS_TOTAL, STATS_TOTAL, null, total));
        return total;
    }

    protected String contentProperty(String propName) {
        return propName + "/length";
    }

    protected String notNullNxql(String nxql, List<Map<String, String>> featuresWithType) {
        StringBuilder buffy = new StringBuilder(nxql);
        block6: for (Map<String, String> prop : featuresWithType) {
            String propName = prop.get("name");
            switch (prop.get("type")) {
                case "img": {
                    buffy.append(" AND ").append(this.contentProperty(propName)).append(" IS NOT NULL");
                    continue block6;
                }
            }
            buffy.append(" AND ").append(propName).append(" IS NOT NULL");
        }
        return buffy.toString();
    }
}

