/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ai.model.serving;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ai.enrichment.EnrichmentUtils;
import org.nuxeo.ai.model.ModelProperty;
import org.nuxeo.ai.model.serving.ModelDescriptor;
import org.nuxeo.ai.model.serving.RuntimeModel;
import org.nuxeo.ai.pipes.functions.PropertyUtils;
import org.nuxeo.ai.rest.RestClient;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.DocumentModel;

public abstract class AbstractRuntimeModel
implements RuntimeModel {
    public static final String LIVENESS = "liveness.";
    public static final String DEFAULT_CONFIDENCE = "0.7";
    protected static final Log log = LogFactory.getLog(AbstractRuntimeModel.class);
    protected String id;
    protected Set<ModelProperty> inputs;
    protected Set<ModelProperty> outputs;
    protected Map<String, String> info;
    protected float minConfidence;
    protected String transientStore;
    protected int imageWidth;
    protected int imageHeight;
    protected int imageDepth;
    protected String imageFormat;

    @Override
    public void init(ModelDescriptor descriptor) {
        this.id = descriptor.id;
        this.inputs = descriptor.getInputs();
        this.outputs = descriptor.getOutputs();
        this.info = descriptor.info;
        Map<String, String> config = descriptor.configuration;
        this.minConfidence = Float.parseFloat(config.getOrDefault("minConfidence", DEFAULT_CONFIDENCE));
        this.imageWidth = EnrichmentUtils.optionAsInteger(config, (String)"width", (int)299);
        this.imageHeight = EnrichmentUtils.optionAsInteger(config, (String)"height", (int)299);
        this.imageDepth = EnrichmentUtils.optionAsInteger(config, (String)"depth", (int)16);
        this.imageFormat = config.getOrDefault("conversionFormat", "jpg");
        String transientStoreName = config.get("transientStore");
        if (StringUtils.isNotBlank((CharSequence)transientStoreName)) {
            this.transientStore = transientStoreName;
        }
        this.isLive(config, LIVENESS);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public Map<String, String> getInfo() {
        return this.info;
    }

    @Override
    public Set<ModelProperty> getInputs() {
        return this.inputs;
    }

    @Override
    public Set<ModelProperty> getOutputs() {
        return this.outputs;
    }

    @Override
    public String getName() {
        return this.info.get("modelName");
    }

    @Override
    public String getVersion() {
        return this.info.get("modelVersion");
    }

    public String saveJsonAsRawBlob(String rawJson) {
        if (this.transientStore != null && StringUtils.isNotBlank((CharSequence)rawJson)) {
            return EnrichmentUtils.saveRawBlob((Blob)Blobs.createJSONBlob((String)rawJson), (String)this.transientStore);
        }
        return null;
    }

    public Map<String, Serializable> getProperties(DocumentModel doc) {
        HashMap<String, Serializable> props = new HashMap<String, Serializable>(this.inputs.size());
        block6: for (ModelProperty input : this.inputs) {
            switch (input.getType()) {
                case "img": {
                    props.put(input.getName(), this.convertImageBlob((Blob)PropertyUtils.getPropertyValue((DocumentModel)doc, (String)input.getName(), Blob.class)));
                    continue block6;
                }
            }
            props.put(input.getName(), (Serializable)PropertyUtils.getPropertyValue((DocumentModel)doc, (String)input.getName(), String.class));
        }
        return props;
    }

    protected Serializable convertImageBlob(Blob sourceBlob) {
        if (sourceBlob != null) {
            Blob blob = EnrichmentUtils.convertImageBlob((Blob)sourceBlob, (int)this.imageWidth, (int)this.imageHeight, (int)this.imageDepth, (String)this.imageFormat);
            return PropertyUtils.base64EncodeBlob((Blob)blob);
        }
        return null;
    }

    public boolean isLive(Map<String, String> config, String prefix) {
        String uri = config.get(prefix + "uri");
        if (StringUtils.isNotBlank((CharSequence)uri)) {
            boolean live = RestClient.isLive(config, (String)prefix);
            if (!live) {
                log.warn((Object)String.format("Live check failed for %s", uri));
            }
            return live;
        }
        return false;
    }
}

