/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ai.model.serving;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.nuxeo.ai.model.ModelProperty;
import org.nuxeo.ai.model.serving.RuntimeModel;
import org.nuxeo.ai.model.serving.TFRuntimeModel;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.core.api.NuxeoException;

@XObject(value="model")
public class ModelDescriptor {
    private static final Class<? extends RuntimeModel> DEFAULT_MODEL_CLASS = TFRuntimeModel.class;
    @XNode(value="@id")
    public String id;
    @XNodeMap(value="config", key="@name", type=HashMap.class, componentType=String.class)
    public Map<String, String> configuration = new HashMap<String, String>();
    @XNodeMap(value="info", key="@name", type=HashMap.class, componentType=String.class)
    public Map<String, String> info = new HashMap<String, String>();
    @XNode(value="filter")
    public ModelPredicate filter;
    @XNode(value="inputProperties")
    protected InputProperties inputProperties;
    @XNode(value="outputProperties")
    protected OutputProperties outputProperties;
    @XNode(value="@class")
    protected Class<? extends RuntimeModel> clazz;

    public Set<ModelProperty> getInputs() {
        return this.inputProperties.properties;
    }

    public Set<ModelProperty> getOutputs() {
        return this.outputProperties.properties;
    }

    public RuntimeModel getModel() {
        try {
            if (this.clazz == null) {
                this.clazz = DEFAULT_MODEL_CLASS;
            }
            RuntimeModel model = this.clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            model.init(this);
            return model;
        }
        catch (ReflectiveOperationException e) {
            throw new NuxeoException(String.format("ModelDescriptor for %s is invalid.", this.id), (Throwable)e);
        }
    }

    @XObject(value="outputProperties")
    public static class OutputProperties {
        @XNodeList(value="property", type=HashSet.class, componentType=ModelProperty.class)
        protected Set<ModelProperty> properties = new HashSet<ModelProperty>();
    }

    @XObject(value="inputProperties")
    public static class InputProperties {
        @XNodeList(value="property", type=HashSet.class, componentType=ModelProperty.class)
        protected Set<ModelProperty> properties = new HashSet<ModelProperty>();
    }

    @XObject(value="filter")
    public static class ModelPredicate {
        @XNode(value="@primaryType")
        String primaryType;
    }
}

