/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ai.model.serving;

import java.io.IOException;
import java.util.List;
import org.nuxeo.ai.metadata.SuggestionMetadata;
import org.nuxeo.ai.model.serving.ModelServingService;
import org.nuxeo.ai.pipes.services.JacksonUtil;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;

@Operation(id="AI.Suggestion", category="Document", label="Ask for a suggestion.", description="Calls intelligent services on the provided document and returns suggested metadata.")
public class SuggestionOp {
    public static final String ID = "AI.Suggestion";
    public static final String EMPTY_JSON_LIST = "[]";
    @Context
    public CoreSession coreSession;
    @Context
    protected ModelServingService modelServingService;
    @Param(name="document", description="A document", required=false)
    protected DocumentModel documentModel;

    @OperationMethod
    public Blob run(DocumentModel doc) throws IOException {
        List<SuggestionMetadata> suggestions;
        if (doc == null || (suggestions = this.modelServingService.predict(doc)) == null || suggestions.isEmpty()) {
            return Blobs.createJSONBlob((String)EMPTY_JSON_LIST);
        }
        return Blobs.createJSONBlob((String)JacksonUtil.MAPPER.writeValueAsString(suggestions));
    }

    @OperationMethod
    public Blob run(DocumentRef docRef) throws IOException {
        DocumentModel docModel = this.coreSession.getDocument(docRef);
        return this.run(docModel);
    }

    @OperationMethod
    public Blob run() throws IOException {
        return this.run(this.documentModel);
    }
}

