/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.client.jsf;

import java.io.Serializable;
import javax.faces.context.FacesContext;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Begin;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.web.RequestParameter;
import org.jboss.seam.contexts.Context;
import org.nuxeo.connect.data.DownloadablePackage;
import org.nuxeo.connect.packages.PackageManager;
import org.nuxeo.ecm.admin.AdminViewManager;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.api.WebActions;
import org.nuxeo.ecm.platform.util.RepositoryLocation;
import org.nuxeo.runtime.api.Framework;

@Name(value="externalLinkManager")
@Scope(value=ScopeType.SESSION)
public class ExternalLinkManager
implements Serializable {
    private static final long serialVersionUID = 1L;
    @RequestParameter
    protected String packageId;
    protected DownloadablePackage pkg;
    @In(create=true, required=false)
    protected WebActions webActions;
    @In(create=true, required=false)
    protected AdminViewManager adminViews;
    @In
    protected transient Context sessionContext;
    @In(create=true)
    protected transient NavigationContext navigationContext;
    @In(create=true)
    protected transient RepositoryManager repositoryManager;

    protected static NuxeoPrincipal getUser() {
        return (NuxeoPrincipal)FacesContext.getCurrentInstance().getExternalContext().getUserPrincipal();
    }

    protected void setupCurrentUser() {
        this.sessionContext.set("currentUser", (Object)ExternalLinkManager.getUser());
    }

    @Begin(id="#{conversationIdGenerator.nextMainConversationId}", join=true)
    public String startDownload() {
        if (this.packageId == null) {
            return null;
        }
        PackageManager pm = (PackageManager)Framework.getLocalService(PackageManager.class);
        this.pkg = pm.getPackage(this.packageId);
        if (ExternalLinkManager.getUser().isAdministrator() && this.pkg != null) {
            return "confirm_download";
        }
        return "can_not_download";
    }

    public DownloadablePackage getPkg() {
        return this.pkg;
    }

    protected void initMinimalContext() throws ClientException {
        this.setupCurrentUser();
        if (this.navigationContext.getCurrentServerLocation() == null) {
            RepositoryLocation repLoc = new RepositoryLocation((String)this.repositoryManager.getRepositoryNames().get(0));
            this.navigationContext.setCurrentServerLocation(repLoc);
        }
        CoreSession documentManager = this.navigationContext.getOrCreateDocumentManager();
        DocumentModelList domains = documentManager.query("select * from Domain");
        this.navigationContext.setCurrentDocument((DocumentModel)domains.get(0));
    }

    public String confirm() throws ClientException {
        this.initMinimalContext();
        this.webActions.setCurrentTabId("NUXEO_ADMIN", "ConnectApps", new String[]{"ConnectAppsRemote"});
        this.adminViews.addExternalPackageDownloadRequest(this.pkg.getId());
        return "view_admin";
    }
}

