/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.impl.task.commands;

import java.io.File;
import java.util.Map;
import org.nuxeo.connect.update.PackageException;
import org.nuxeo.connect.update.ValidationStatus;
import org.nuxeo.connect.update.impl.task.AbstractCommand;
import org.nuxeo.connect.update.impl.task.Command;
import org.nuxeo.connect.update.impl.task.commands.Deploy;
import org.nuxeo.connect.update.impl.xml.XmlWriter;
import org.nuxeo.connect.update.task.Task;
import org.nuxeo.runtime.api.Framework;
import org.w3c.dom.Element;

public class UndeployConfig
extends AbstractCommand {
    public static final String ID = "undeploy-config";
    protected File file;

    public UndeployConfig() {
        super(ID);
    }

    public UndeployConfig(File file) {
        super(ID);
        this.file = file;
    }

    @Override
    protected void doValidate(Task task, ValidationStatus status) throws PackageException {
    }

    @Override
    protected Command doRun(Task task, Map<String, String> prefs) throws PackageException {
        try {
            Framework.getRuntime().getContext().undeploy(this.file.toURI().toURL());
        }
        catch (Exception e) {
            throw new PackageException("Failed to undeploy configuration file " + this.file, (Throwable)e);
        }
        return new Deploy(this.file);
    }

    @Override
    public void readFrom(Element element) throws PackageException {
        String v = element.getAttribute("file");
        if (v.length() > 0) {
            this.file = new File(v);
            this.guardVars.put("file", this.file);
        }
    }

    @Override
    public void writeTo(XmlWriter writer) {
        writer.start(ID);
        if (this.file != null) {
            writer.attr("file", this.file.getAbsolutePath());
        }
        writer.end();
    }
}

