/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.impl.xml;

import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.connect.update.NuxeoValidationState;
import org.nuxeo.connect.update.PackageDependency;
import org.nuxeo.connect.update.PackageType;
import org.nuxeo.connect.update.ProductionState;
import org.nuxeo.connect.update.Version;
import org.nuxeo.connect.update.impl.xml.TaskDefinitionImpl;
import org.nuxeo.connect.update.impl.xml.XmlSerializer;
import org.nuxeo.connect.update.impl.xml.XmlWriter;
import org.nuxeo.connect.update.model.PackageDefinition;
import org.nuxeo.connect.update.model.TaskDefinition;

@XObject(value="package")
public class PackageDefinitionImpl
implements PackageDefinition {
    @XNode(value="@name")
    protected String name;
    @XNode(value="@version")
    protected Version version;
    @XNode(value="@type")
    protected PackageType type;
    @XNode(value="title")
    protected String title;
    @XNode(value="description")
    protected String description;
    @XNode(value="classifier")
    protected String classifier;
    @XNode(value="vendor")
    protected String vendor;
    @XNode(value="home-page")
    protected String homePage;
    @XNode(value="supported")
    protected boolean supported = false;
    @XNode(value="hotreload-support")
    protected boolean hotReloadSupport = false;
    @XNode(value="require-terms-and-conditions-acceptance")
    protected boolean requireTermsAndConditionsAcceptance = false;
    protected NuxeoValidationState validationState = NuxeoValidationState.NONE;
    protected ProductionState productionState = ProductionState.TESTING;
    @XNode(value="license")
    protected String license;
    @XNode(value="license-url")
    protected String licenseUrl;
    @XNodeList(value="platforms/platform", type=String[].class, componentType=String.class)
    protected String[] platforms;
    @XNodeList(value="dependencies/package", type=PackageDependency[].class, componentType=PackageDependency.class)
    protected PackageDependency[] dependencies;
    @XNode(value="installer")
    protected TaskDefinitionImpl installer;
    @XNode(value="uninstaller")
    protected TaskDefinitionImpl uninstaller;
    @XNode(value="validator")
    protected String validator;

    @XNode(value="nuxeo-validation")
    protected void initNuxeoValidationState(String value) {
        NuxeoValidationState targetState = NuxeoValidationState.getByValue((String)value);
        if (targetState != null) {
            this.validationState = targetState;
        }
    }

    @XNode(value="production-state")
    protected void initProductionState(String value) {
        ProductionState targetState = ProductionState.getByValue((String)value);
        if (targetState != null) {
            this.productionState = targetState;
        }
    }

    public String getId() {
        if (this.version == null) {
            return this.name;
        }
        return this.name + "-" + this.version.toString();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public PackageType getType() {
        return this.type;
    }

    public void setType(PackageType type) {
        this.type = type;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public String getHomePage() {
        return this.homePage;
    }

    public void setHomePage(String homePage) {
        this.homePage = homePage;
    }

    public String getLicense() {
        return this.license;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public String getLicenseUrl() {
        return this.licenseUrl;
    }

    public void setLicenseUrl(String licenseUrl) {
        this.licenseUrl = licenseUrl;
    }

    public String[] getPlatforms() {
        return this.platforms;
    }

    public void setPlatforms(String[] platforms) {
        this.platforms = platforms;
    }

    public PackageDependency[] getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(PackageDependency[] dependencies) {
        this.dependencies = dependencies;
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public TaskDefinition getInstaller() {
        return this.installer;
    }

    public void setInstaller(TaskDefinition installer) {
        this.installer = installer instanceof TaskDefinitionImpl ? (TaskDefinitionImpl)installer : new TaskDefinitionImpl(installer.getType(), installer.getRequireRestart());
    }

    public TaskDefinition getUninstaller() {
        return this.uninstaller;
    }

    public void setUninstaller(TaskDefinition uninstaller) {
        this.uninstaller = uninstaller instanceof TaskDefinitionImpl ? (TaskDefinitionImpl)uninstaller : new TaskDefinitionImpl(uninstaller.getType(), uninstaller.getRequireRestart());
    }

    public String getValidator() {
        return this.validator;
    }

    public void setValidator(String validator) {
        this.validator = validator;
    }

    public void setSupported(boolean supported) {
        this.supported = supported;
    }

    public void setHotReloadSupport(boolean hotReloadSupport) {
        this.hotReloadSupport = hotReloadSupport;
    }

    public void setValidationState(NuxeoValidationState validationState) {
        this.validationState = validationState;
    }

    public void setProductionState(ProductionState productionState) {
        this.productionState = productionState;
    }

    @Deprecated
    public void write(XmlWriter writer) {
        writer.writeXmlDecl();
        writer.start("package");
        writer.attr("name", this.name);
        if (this.version != null) {
            writer.attr("version", this.version.toString());
        }
        if (this.type != null) {
            writer.attr("type", this.type.getValue());
        }
        writer.startContent();
        writer.element("title", this.title);
        writer.element("description", this.description);
        writer.element("classifier", this.classifier);
        writer.element("vendor", this.vendor);
        writer.element("home-page", this.homePage);
        writer.element("license", this.license);
        writer.element("license-url", this.licenseUrl);
        writer.element("hotreload-support", Boolean.valueOf(this.hotReloadSupport).toString());
        writer.element("supported", Boolean.valueOf(this.supported).toString());
        writer.element("require-terms-and-conditions-acceptance", Boolean.valueOf(this.requireTermsAndConditionsAcceptance).toString());
        writer.element("production-state", this.productionState.toString());
        writer.element("nuxeo-validation", this.validationState.toString());
        if (this.platforms != null) {
            writer.start("platforms");
            writer.startContent();
            for (String string : this.platforms) {
                writer.element("platform", string);
            }
            writer.end("platforms");
        }
        if (this.dependencies != null) {
            writer.start("dependencies");
            writer.startContent();
            for (String string : this.dependencies) {
                writer.element("package", string.toString());
            }
            writer.end("dependencies");
        }
        if (this.installer != null) {
            writer.start("installer");
            writer.attr("class", this.installer.getType());
            writer.attr("restart", String.valueOf(this.installer.getRequireRestart()));
            writer.end();
        }
        if (this.uninstaller != null) {
            writer.start("uninstaller");
            writer.attr("class", this.installer.getType());
            writer.attr("restart", String.valueOf(this.installer.getRequireRestart()));
            writer.end();
        }
        writer.element("validator", this.validator);
        writer.end("package");
    }

    public ProductionState getProductionState() {
        return this.productionState;
    }

    public NuxeoValidationState getValidationState() {
        return this.validationState;
    }

    public boolean isSupported() {
        return this.supported;
    }

    public boolean supportsHotReload() {
        return this.hotReloadSupport;
    }

    public void setRequireTermsAndConditionsAcceptance(boolean requireTermsAndConditionsAcceptance) {
        this.requireTermsAndConditionsAcceptance = requireTermsAndConditionsAcceptance;
    }

    public boolean requireTermsAndConditionsAcceptance() {
        return this.requireTermsAndConditionsAcceptance;
    }

    public String toXML() {
        return new XmlSerializer().toXML(this);
    }
}

