/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.wss.servlet;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.wss.WSSConfig;
import org.nuxeo.wss.WSSException;
import org.nuxeo.wss.fm.FreeMarkerRenderer;
import org.nuxeo.wss.fprpc.FPRPCRequest;
import org.nuxeo.wss.fprpc.FPRPCResponse;
import org.nuxeo.wss.handlers.fakews.FakeWSRequest;
import org.nuxeo.wss.handlers.fakews.FakeWSRouter;
import org.nuxeo.wss.handlers.fprpc.FPRPCRouter;
import org.nuxeo.wss.handlers.get.SimpleGetHandler;
import org.nuxeo.wss.handlers.resources.ResourcesHandler;
import org.nuxeo.wss.servlet.WSSRequest;
import org.nuxeo.wss.servlet.WSSResponse;
import org.nuxeo.wss.servlet.config.FilterBindingConfig;
import org.nuxeo.wss.servlet.config.FilterBindingResolver;
import org.nuxeo.wss.spi.Backend;
import org.nuxeo.wss.spi.WSSBackend;

public class WSSFilter
implements Filter {
    protected SimpleGetHandler simpleGetHandler;
    protected ResourcesHandler resourcesHandler;
    protected FilterConfig filterConfig;
    protected Boolean rootFilter = null;
    protected String rootFilterTarget = null;
    public static final String ROOT_FILTER_PARAM = "org.nuxeo.wss.rootFilter";
    public static final String BACKEND_FACTORY_PARAM = "org.nuxeo.wss.backendFactory";
    public static final String FILTER_FORWARD_PARAM = "org.nuxeo.wss.forwardedFilter";
    public static final String WSSFORWARD_KEY = "WSSForward";
    private static final Log log = LogFactory.getLog(WSSFilter.class);

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest) {
            String forward;
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            String uri = httpRequest.getRequestURI();
            if (this.isRootFilter() && (forward = httpRequest.getParameter(WSSFORWARD_KEY)) != null) {
                httpResponse.sendRedirect(forward);
                return;
            }
            if (this.isRootFilter() && uri.startsWith(this.getRootFilterTarget())) {
                log.debug((Object)"let WSS request to to back filter");
                chain.doFilter(request, response);
                return;
            }
            Object forwardedConfig = httpRequest.getAttribute(FILTER_FORWARD_PARAM);
            try {
                if (forwardedConfig != null) {
                    log.debug((Object)"handle call forwarded by root filter");
                    this.handleWSSCall(httpRequest, httpResponse, (FilterBindingConfig)forwardedConfig);
                    return;
                }
                if ("OPTIONS".equals(httpRequest.getMethod())) {
                    this.handleOptionCall(httpRequest, httpResponse);
                    return;
                }
                FilterBindingConfig config = FilterBindingResolver.getBinding(httpRequest);
                if (config != null) {
                    if (this.isRootFilter()) {
                        log.debug((Object)"Forward call to backend filter");
                        httpRequest.setAttribute(FILTER_FORWARD_PARAM, (Object)config);
                        httpRequest.getSession().getServletContext().getContext(this.getRootFilterTarget()).getRequestDispatcher(httpRequest.getRequestURI()).forward(request, response);
                    } else {
                        this.handleWSSCall(httpRequest, httpResponse, config);
                    }
                    return;
                }
            }
            catch (Exception e) {
                throw new ServletException("error processing request", (Throwable)e);
            }
        }
        chain.doFilter(request, response);
    }

    protected void handleWSSCall(HttpServletRequest httpRequest, HttpServletResponse httpResponse, FilterBindingConfig config) throws Exception {
        WSSRequest request = new WSSRequest(httpRequest, config.getSiteName());
        WSSResponse response = null;
        WSSBackend backend = Backend.get(request);
        log.debug((Object)("Handling WSS call : " + httpRequest.getRequestURL().toString()));
        try {
            if ("FP".equals(config.getRequestType())) {
                FPRPCRequest fpRequest = new FPRPCRequest(httpRequest, config.getSiteName());
                request = fpRequest;
                response = new FPRPCResponse(httpResponse);
                FPRPCRouter.handleFPRCPRequest(fpRequest, (FPRPCResponse)response, config);
            } else if ("GET".equals(config.getRequestType())) {
                response = new WSSResponse(httpResponse);
                this.simpleGetHandler.handleRequest(request, response);
            } else {
                if ("RESOURCES".equals(config.getRequestType())) {
                    this.resourcesHandler.handleResource(httpRequest, httpResponse);
                    return;
                }
                if ("FakeWS".equals(config.getRequestType())) {
                    FakeWSRequest wsRequest = new FakeWSRequest(httpRequest, config.getSiteName());
                    request = wsRequest;
                    response = new WSSResponse(httpResponse);
                    FakeWSRouter.handleFakeWSRequest(wsRequest, response, config);
                }
            }
            if (response == null) {
                log.error((Object)"no response was created by WSS call handling");
                throw new ServletException("WSSResponse is not set");
            }
            response.processIfNeeded();
            backend.saveChanges();
        }
        catch (Exception e) {
            if (backend != null) {
                backend.discardChanges();
            }
            log.error((Object)"Error during WSS call processing", (Throwable)e);
            throw new WSSException("Error while processing WSS request", e);
        }
    }

    protected void handleOptionCall(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws Exception {
        WSSResponse response = new WSSResponse(httpResponse);
        httpResponse.setHeader("MS-Author-Via", "MS-FP/4.0,DAV");
        httpResponse.setHeader("MicrosoftOfficeWebServer", "5.0_Collab");
        httpResponse.setHeader("X-MSDAVEXT", "1");
        httpResponse.setHeader("DocumentManagementServer", "Properties Schema;Source Control;Version History;");
        httpResponse.setHeader("DAV", "1,2");
        httpResponse.setHeader("Accept-Ranges", "none");
        httpResponse.setHeader("Allow", "GET, POST, OPTIONS, HEAD, MKCOL, PUT, PROPFIND, PROPPATCH, DELETE, MOVE, COPY, GETLIB, LOCK, UNLOCK");
        response.process();
    }

    protected String getRootFilterTarget() {
        return this.rootFilterTarget;
    }

    protected boolean isRootFilter() {
        if (this.rootFilter == null) {
            if (this.filterConfig != null) {
                String target = this.filterConfig.getInitParameter(ROOT_FILTER_PARAM);
                if (target != null && !"".equals(target)) {
                    this.rootFilter = true;
                    this.rootFilterTarget = target;
                } else {
                    this.rootFilter = false;
                }
            } else {
                this.rootFilter = false;
            }
        }
        return this.rootFilter;
    }

    public synchronized void init(FilterConfig filterConfig) throws ServletException {
        String factoryName;
        this.simpleGetHandler = new SimpleGetHandler();
        this.resourcesHandler = new ResourcesHandler();
        this.filterConfig = filterConfig;
        if (filterConfig != null && (factoryName = filterConfig.getInitParameter(BACKEND_FACTORY_PARAM)) != null) {
            WSSConfig.instance().setWssBackendFactoryClassName(factoryName);
            Class<?> factoryKlass = Backend.getFactory().getClass();
            FreeMarkerRenderer.addLoader(factoryKlass);
        }
        if (this.isRootFilter()) {
            WSSConfig.instance().setContextPath(this.rootFilterTarget);
        }
    }

    public void destroy() {
    }
}

