/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.wss.servlet;

import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import org.nuxeo.wss.WSSConfig;

public class WSSRequest {
    protected HttpServletRequest httpRequest;
    protected String sitePath;

    public WSSRequest(HttpServletRequest httpRequest, String sitePath) {
        this.httpRequest = httpRequest;
        this.sitePath = sitePath;
    }

    public HttpServletRequest getHttpRequest() {
        return this.httpRequest;
    }

    public String getBaseUrl() {
        return this.getBaseUrl(null);
    }

    public String getBaseUrl(String fpDir) {
        StringBuffer base = new StringBuffer();
        base.append(this.getHttpRequest().getScheme());
        base.append("://");
        base.append(this.getHttpRequest().getServerName());
        if (this.getHttpRequest().getServerPort() != 80) {
            base.append(":");
            base.append(this.getHttpRequest().getServerPort());
        }
        base.append("/");
        return base.toString();
    }

    public String getResourcesUrl() {
        StringBuffer base = new StringBuffer();
        base.append(this.getBaseUrl());
        base.append(WSSConfig.instance().getWSSUrlPrefix());
        String resourcePattern = WSSConfig.instance().getResourcesUrlPattern();
        if (!resourcePattern.startsWith("/")) {
            base.append("/");
        }
        base.append(WSSConfig.instance().getResourcesUrlPattern());
        if (!resourcePattern.endsWith("/")) {
            base.append("/");
        }
        return base.toString();
    }

    public String getUserName() {
        Principal principal = this.getHttpRequest().getUserPrincipal();
        if (principal == null) {
            return "";
        }
        return principal.getName();
    }

    public String getSitePath() {
        return this.sitePath;
    }
}

