/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.wss.servlet;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.nuxeo.wss.WSSConfig;
import org.nuxeo.wss.fm.FreeMarkerRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSSResponse {
    protected HttpServletResponse httpResponse;
    protected boolean processed = false;
    protected boolean bufferizeRendering = true;
    protected static final int BUFFER_SIZE = 10240;
    protected Map<String, Object> renderingContext = new HashMap<String, Object>();
    protected String renderingTemplateName = null;
    protected InputStream additionnalStream;
    protected String contentType = null;

    public WSSResponse(HttpServletResponse httpResponse) {
        this.httpResponse = httpResponse;
    }

    public void processIfNeeded() throws Exception {
        if (!this.processed) {
            this.process();
        }
    }

    public void process() throws Exception {
        if (this.processed) {
            throw new ServletException("process called twice on WSSResponse");
        }
        this.processHeaders();
        this.processRender();
        this.processed = true;
    }

    public void addBinaryStream(InputStream stream) {
        this.additionnalStream = stream;
    }

    protected void processHeaders() throws Exception {
        this.getHttpResponse().setHeader("MicrosoftSharePointTeamServices", WSSConfig.instance().getTSServerVersion());
        this.getHttpResponse().setHeader("Set-Cookie", "WSS_KeepSessionAuthenticated=80; path=/");
        this.getHttpResponse().setHeader("X-Powered-By", "ASP.NET");
        if (this.contentType == null) {
            this.getHttpResponse().setHeader("Content-type", this.getDefaultContentType());
        } else {
            this.getHttpResponse().setHeader("Content-type", this.contentType);
        }
    }

    protected String getDefaultContentType() {
        return "text/plain";
    }

    protected void processRender() throws Exception {
        if (this.renderingTemplateName != null) {
            BufferedWriter writer = null;
            ByteArrayOutputStream bufferedOs = null;
            if (this.bufferizeRendering) {
                bufferedOs = new ByteArrayOutputStream();
                writer = new BufferedWriter(new OutputStreamWriter(bufferedOs));
            } else {
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)this.getHttpResponse().getOutputStream()));
            }
            FreeMarkerRenderer.instance().render(this.renderingTemplateName, this.renderingContext, writer);
            ((Writer)writer).flush();
            if (this.bufferizeRendering && this.additionnalStream != null) {
                int read;
                byte[] buffer = new byte[10240];
                while ((read = this.additionnalStream.read(buffer)) != -1) {
                    bufferedOs.write(buffer, 0, read);
                    bufferedOs.flush();
                }
            }
            ((Writer)writer).close();
            if (this.bufferizeRendering) {
                int size = bufferedOs.size();
                this.getHttpResponse().setContentLength(size);
                ServletOutputStream out = this.getHttpResponse().getOutputStream();
                out.write(bufferedOs.toByteArray());
                out.close();
            }
        }
    }

    public HttpServletResponse getHttpResponse() {
        return this.httpResponse;
    }

    public boolean isProcessed() {
        return this.processed;
    }

    public void setProcessed(boolean processed) {
        this.processed = processed;
    }

    public Map<String, Object> getRenderingContext() {
        return this.renderingContext;
    }

    public void setRenderingContext(Map<String, Object> renderingContext) {
        this.renderingContext = renderingContext;
    }

    public String getRenderingTemplateName() {
        return this.renderingTemplateName;
    }

    public void setRenderingTemplateName(String renderingTemplateName) {
        this.renderingTemplateName = renderingTemplateName;
    }

    public void addRenderingParameter(String name, Object value) {
        this.renderingContext.put(name, value);
    }

    public void setContentType(String ct) {
        this.contentType = ct;
    }
}

