/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.wss.spi;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.nuxeo.wss.spi.WSSListItem;

public abstract class AbstractWSSListItem
implements WSSListItem {
    public static final SimpleDateFormat WSS_DATE_FORMAT = new SimpleDateFormat("dd MMM yyyy HH:mm:ss -0000", Locale.US);
    protected String icon;
    protected boolean isSiteItem = false;

    public boolean isFolderish() {
        return "folder".equals(this.getType());
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getCreatedTS() {
        return WSS_DATE_FORMAT.format(this.getCreationDate());
    }

    public String getModifiedTS() {
        return WSS_DATE_FORMAT.format(this.getModificationDate());
    }

    protected abstract Date getCheckoutDate();

    protected abstract Date getCheckoutExpiryDate();

    public String getCheckoutTS() {
        return WSS_DATE_FORMAT.format(this.getCheckoutDate());
    }

    public String getCheckoutExpiryTS() {
        return WSS_DATE_FORMAT.format(this.getCheckoutExpiryDate());
    }

    protected String getExtension() {
        String[] parts;
        String filename = this.getName();
        if (filename != null && (parts = filename.split("\\.")).length > 1) {
            return parts[parts.length - 1];
        }
        return null;
    }

    protected String getIconFromType() {
        if (this.isFolderish()) {
            return "folder.gif";
        }
        String ext = this.getExtension();
        if (ext != null) {
            if (ext.toLowerCase().equals("gif") || ext.toLowerCase().equals("jpg") || ext.toLowerCase().equals("png") || ext.toLowerCase().equals("jpeg") || ext.toLowerCase().equals("tif")) {
                ext = "image";
            }
            return ext + ".gif";
        }
        return "file.gif";
    }

    public String getIcon() {
        if (this.icon == null) {
            return this.getIconFromType();
        }
        return this.icon;
    }

    public String getSizeAsString() {
        return "" + this.getSize();
    }

    public String getDisplayName() {
        return this.getName();
    }

    public String getRelativeSubPath(String siteRootPath) {
        String subPath = this.getSubPath();
        if (siteRootPath != null && !"".equals(siteRootPath)) {
            if (subPath.startsWith("/")) {
                subPath = subPath.substring(1);
            }
            if (siteRootPath.startsWith("/")) {
                siteRootPath = siteRootPath.substring(1);
            }
            subPath = subPath.replace(siteRootPath, "");
        }
        if (subPath.startsWith("/")) {
            subPath = subPath.substring(1);
        }
        return subPath;
    }

    public String getRelativeFilePath(String siteRootPath) {
        return this.getRelativeSubPath(siteRootPath);
    }

    public boolean isSite() {
        return this.isSiteItem;
    }

    public boolean isCheckOut() {
        String lockingUser = this.getCheckoutUser();
        return lockingUser != null;
    }

    public boolean canCheckOut(String userName) {
        String lockingUser = this.getCheckoutUser();
        if (lockingUser == null) {
            return true;
        }
        return lockingUser.equals(userName);
    }

    public boolean canUnCheckOut(String userName) {
        String lockingUser = this.getCheckoutUser();
        if (lockingUser == null) {
            return false;
        }
        return lockingUser.equals(userName);
    }
}

