/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.wss.spi.dummy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.wss.spi.WSSListItem;
import org.nuxeo.wss.spi.dummy.DummyWSSListItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DummyMemoryTree {
    protected WSSListItem root;
    protected Map<String, List<WSSListItem>> allitems = new HashMap<String, List<WSSListItem>>();
    public static final int DEPTH = 3;
    protected static DummyMemoryTree instance = null;

    public static synchronized DummyMemoryTree instance() {
        if (instance == null) {
            instance = new DummyMemoryTree();
            instance.init();
        }
        return instance;
    }

    public static void resetInstance() {
        instance = null;
    }

    public WSSListItem getItem(String location) {
        if (location == null || location == "" || location == "/") {
            return this.root;
        }
        if (location.startsWith("/")) {
            location = location.substring(1);
        }
        for (String key : this.allitems.keySet()) {
            for (WSSListItem item : this.allitems.get(key)) {
                if (!item.getSubPath().equals(location)) continue;
                return item;
            }
        }
        return null;
    }

    public List<WSSListItem> listItems(String location) {
        List<WSSListItem> items = this.allitems.get(location);
        if (items == null && location.startsWith("/")) {
            items = this.allitems.get(location.substring(1));
        }
        return items;
    }

    protected void generateChildren(String basePath) {
        int depth = basePath.split("/").length;
        ArrayList<DummyWSSListItem> items = new ArrayList<DummyWSSListItem>();
        if (depth == 0) {
            for (int i = 0; i < 5; ++i) {
                items.add(new DummyWSSListItem("DocLib" + i, "This is Dummy Document Libray " + i, null));
            }
        } else {
            int i;
            if (depth <= 3) {
                for (i = 0; i < 5; ++i) {
                    items.add(new DummyWSSListItem("Workspace-" + depth + "-" + i, "This is Dummy Workspace " + i, basePath, null));
                }
            }
            for (i = 0; i < 5; ++i) {
                String string = "FakeContent" + i;
                DummyWSSListItem item = new DummyWSSListItem("Document-" + depth + "-" + i + ".doc", "This is Dummy File " + i, basePath, null);
                item.setBinaryResourcePath("sampledoc/hello.doc");
                item.setSize(7680);
                items.add(item);
            }
            DummyWSSListItem item = new DummyWSSListItem("ShellError.txt", "Simple text file", basePath, null);
            item.setBinaryResourcePath("sampledoc/ShellError.txt");
            item.setSize(1123);
            items.add(item);
        }
        this.allitems.put(basePath, items);
        if (depth <= 3) {
            for (WSSListItem wSSListItem : items) {
                if (!wSSListItem.isFolderish()) continue;
                this.generateChildren(wSSListItem.getSubPath());
            }
        }
    }

    protected void init() {
        this.root = new DummyWSSListItem("/", "Root node", null);
        this.generateChildren("/");
    }
}

