/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.groups.audit.service.acl.job.publish;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.InvalidChainException;
import org.nuxeo.ecm.automation.OperationChain;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.OperationParameters;
import org.nuxeo.ecm.automation.core.mail.Mailer;
import org.nuxeo.ecm.automation.core.operations.notification.SendMail;
import org.nuxeo.ecm.automation.core.util.StringList;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.platform.groups.audit.service.acl.job.publish.IResultPublisher;
import org.nuxeo.ecm.platform.groups.audit.service.acl.utils.MessageAccessor;
import org.nuxeo.runtime.api.Framework;

public class PublishByMail
implements IResultPublisher {
    private static final Log log = LogFactory.getLog(PublishByMail.class);
    public static final String PROPERTY_ACLAUDIT_SENDMAIL_CHAIN = "ACL.Audit.SendMail";
    public static final String PROPERTY_MAILFROM = "mail.from";
    public static final String PROPERTY_MAIL_SUBJECT = "message.acl.audit.mail.title";
    public static final String PROPERTY_MAIL_BODY = "message.acl.audit.mail.body";
    public static String FROM = "noreply@nuxeo.com";
    protected final AutomationService automation = (AutomationService)Framework.getLocalService(AutomationService.class);
    protected FileBlob file;
    protected String documentName = "";
    protected String repository;
    protected String to;
    protected String defaultFrom;

    public PublishByMail(FileBlob fb, String to, String defaultFrom, String repository) {
        this.file = fb;
        this.repository = repository;
        this.to = to;
        this.defaultFrom = defaultFrom;
    }

    @Override
    public void publish() throws ClientException {
        this.reconnectAndSendMail();
    }

    protected void reconnectAndSendMail() throws ClientException {
        new UnrestrictedSessionRunner(this.repository){

            public void run() throws ClientException {
                DocumentModel docToSend = PublishByMail.this.createDocument(this.session, (Blob)PublishByMail.this.file, PublishByMail.this.documentName, PublishByMail.this.documentName);
                PublishByMail.this.doCallOperationSendMail(this.session, docToSend, PublishByMail.this.to, PublishByMail.this.defaultFrom);
                log.debug((Object)"audit sent");
            }
        }.runUnrestricted();
    }

    protected void doCallOperationSendMail(CoreSession session, DocumentModel docToSend, String to, String defaultFrom) throws ClientException {
        String title = MessageAccessor.get(session, PROPERTY_MAIL_SUBJECT);
        String body = MessageAccessor.get(session, PROPERTY_MAIL_BODY);
        String from = Framework.getProperty((String)PROPERTY_MAILFROM, (String)defaultFrom);
        OperationContext ctx = new OperationContext(session);
        ctx.setInput((Object)docToSend);
        try {
            OperationChain chain = new OperationChain(PROPERTY_ACLAUDIT_SENDMAIL_CHAIN);
            OperationParameters params = chain.add("Notification.SendMail");
            if (params == null) {
                log.error((Object)("failed to retrieve operation Notification.SendMail in chain " + chain));
                return;
            }
            params.set("from", (Object)from);
            params.set("to", (Object)to);
            params.set("subject", (Object)title);
            params.set("message", (Object)body);
            String[] str = new String[]{"file:content"};
            params.set("files", (Object)new StringList(str));
            log.debug((Object)("Automation run ACL.Audit.SendMail for " + to));
            this.automation.run(ctx, chain);
            log.debug((Object)("Automation done ACL.Audit.SendMail for " + to));
        }
        catch (InvalidChainException e) {
            throw new ClientException((Throwable)e);
        }
        catch (OperationException e) {
            throw new ClientException((Throwable)e);
        }
        catch (Exception e) {
            throw new ClientException((Throwable)e);
        }
    }

    protected OperationParameters findParameters(OperationChain chain, String id) {
        List params = chain.getOperations();
        for (OperationParameters p : params) {
            if (!p.id().equals(id)) continue;
            return p;
        }
        return null;
    }

    protected DocumentModel createDocument(CoreSession session, Blob blob, String title, String filename) throws ClientException {
        DocumentModel document = session.createDocumentModel("File");
        document.setPropertyValue("file:content", (Serializable)blob);
        document.setPropertyValue("file:filename", (Serializable)((Object)filename));
        document.setPropertyValue("dublincore:title", (Serializable)((Object)title));
        return document;
    }

    protected void logMailerConfiguration() {
        Mailer m = SendMail.COMPOSER.getMailer();
        log.info((Object)("mail.smtp.auth:" + m.getConfiguration().get("mail.smtp.auth")));
        log.info((Object)("mail.smtp.starttls.enable:" + m.getConfiguration().get("mail.smtp.starttls.enable")));
        log.info((Object)("mail.smtp.host:" + m.getConfiguration().get("mail.smtp.host")));
        log.info((Object)("mail.smtp.user:" + m.getConfiguration().get("mail.smtp.user")));
        log.info((Object)("mail.smtp.password:" + m.getConfiguration().get("mail.smtp.password")));
    }
}

