/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.groups.audit.service;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.sf.jxls.transformer.XLSTransformer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.platform.groups.audit.service.ExcelExportService;
import org.nuxeo.ecm.platform.groups.audit.service.ExcelExportServiceDescriptor;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class ExcelExportServiceImpl
extends DefaultComponent
implements ExcelExportService {
    public static final Log log = LogFactory.getLog(ExcelExportServiceImpl.class);
    public static final String EXCEL_EXPORT_EP = "excelExportFactory";
    protected static final Map<String, ExcelExportServiceDescriptor> exportExcelRegistry = new HashMap<String, ExcelExportServiceDescriptor>();

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (EXCEL_EXPORT_EP.equals(extensionPoint)) {
            ExcelExportServiceDescriptor desc = (ExcelExportServiceDescriptor)contribution;
            exportExcelRegistry.put(desc.getName(), desc);
        } else {
            log.error((Object)("Unknown extension point " + extensionPoint));
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
    }

    @Override
    public File getExcelReport(String exportName) {
        XLSTransformer transformer = new XLSTransformer();
        File resultReport = null;
        try {
            resultReport = new File(this.getWorkingDir(), "audit-groups.xls");
            resultReport.createNewFile();
            ExcelExportServiceDescriptor descriptor = exportExcelRegistry.get(exportName);
            transformer.transformXLS(descriptor.getTemplate().getAbsolutePath(), descriptor.getFactory().getDataToInject(), resultReport.getAbsolutePath());
        }
        catch (Exception e) {
            log.error((Object)"Unable to create excel report result file:", (Throwable)e);
        }
        return resultReport;
    }

    @Override
    public File getExcelReport(String exportName, Map<String, Object> data) {
        XLSTransformer transformer = new XLSTransformer();
        File resultReport = null;
        try {
            resultReport = new File(this.getWorkingDir(), "audit-groups.xls");
            resultReport.createNewFile();
            ExcelExportServiceDescriptor descriptor = exportExcelRegistry.get(exportName);
            transformer.transformXLS(descriptor.getTemplate().getAbsolutePath(), data, resultReport.getAbsolutePath());
        }
        catch (Exception e) {
            log.error((Object)"Unable to create excel report result file:", (Throwable)e);
        }
        return resultReport;
    }

    protected File getWorkingDir() {
        String dirPath = System.getProperty("java.io.tmpdir") + "/NXExcelExport" + System.currentTimeMillis();
        File workingDir = new File(dirPath);
        if (workingDir.exists()) {
            FileUtils.deleteTree((File)workingDir);
        }
        workingDir.mkdir();
        return workingDir;
    }
}

