/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.test;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.multipart.MultiPart;
import com.sun.jersey.multipart.MultiPartMediaTypes;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.jaxrs.test.CloseableClientResponse;
import org.nuxeo.jaxrs.test.JerseyClientHelper;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class BaseTest {
    protected static final String REST_API_URL = "http://localhost:18090/api/v1/";
    protected ObjectMapper mapper;
    protected Client client;
    protected WebResource service;
    @Inject
    public CoreSession session;

    @Before
    public void doBefore() throws Exception {
        this.service = this.getServiceFor("Administrator", "Administrator");
        this.mapper = new ObjectMapper();
    }

    @After
    public void doAfter() throws Exception {
        this.client.destroy();
    }

    protected WebResource getServiceFor(String username, String password) {
        return this.getServiceFor(REST_API_URL, username, password);
    }

    protected WebResource getServiceFor(String resource, String username, String password) {
        if (this.client != null) {
            this.client.destroy();
        }
        this.client = JerseyClientHelper.clientBuilder().setCredentials(username, password).build();
        return this.client.resource(resource);
    }

    protected CloseableClientResponse getResponse(RequestType requestType, String path) {
        return this.getResponse(requestType, path, null, null, null, null);
    }

    protected CloseableClientResponse getResponse(RequestType requestType, String path, Map<String, String> headers) {
        return this.getResponse(requestType, path, null, null, null, headers);
    }

    protected CloseableClientResponse getResponse(RequestType requestType, String path, MultiPart mp) {
        return this.getResponse(requestType, path, null, null, mp, null);
    }

    protected CloseableClientResponse getResponse(RequestType requestType, String path, MultiPart mp, Map<String, String> headers) {
        return this.getResponse(requestType, path, null, null, mp, headers);
    }

    protected CloseableClientResponse getResponse(RequestType requestType, String path, MultivaluedMap<String, String> queryParams) {
        return this.getResponse(requestType, path, null, queryParams, null, null);
    }

    protected CloseableClientResponse getResponse(RequestType requestType, String path, String data) {
        return this.getResponse(requestType, path, data, null, null, null);
    }

    protected CloseableClientResponse getResponse(RequestType requestType, String path, String data, Map<String, String> headers) {
        return this.getResponse(requestType, path, data, null, null, headers);
    }

    protected CloseableClientResponse getResponse(RequestType requestType, String path, String data, MultivaluedMap<String, String> queryParams, MultiPart mp, Map<String, String> headers) {
        WebResource wr = this.service.path(path);
        if (queryParams != null && !queryParams.isEmpty()) {
            wr = wr.queryParams(queryParams);
        }
        WebResource.Builder builder = requestType == RequestType.GETES ? wr.accept(new String[]{"application/json+esentity"}) : (WebResource.Builder)wr.accept(new String[]{"application/json"}).header("X-NXDocumentProperties", (Object)"dublincore");
        if (headers != null && !headers.isEmpty()) {
            for (String headerKey : headers.keySet()) {
                builder.header(headerKey, (Object)headers.get(headerKey));
            }
        }
        ClientResponse response = null;
        switch (requestType) {
            case GET: 
            case GETES: {
                response = (ClientResponse)builder.get(ClientResponse.class);
                break;
            }
            case POST: 
            case POSTREQUEST: {
                if (mp != null) {
                    response = (ClientResponse)((WebResource.Builder)builder.type(MultiPartMediaTypes.createFormData())).post(ClientResponse.class, (Object)mp);
                    break;
                }
                if (data != null) {
                    this.setJSONContentTypeIfAbsent(builder, headers);
                    response = (ClientResponse)builder.post(ClientResponse.class, (Object)data);
                    break;
                }
                response = (ClientResponse)builder.post(ClientResponse.class);
                break;
            }
            case PUT: {
                if (mp != null) {
                    response = (ClientResponse)((WebResource.Builder)builder.type(MultiPartMediaTypes.createFormData())).put(ClientResponse.class, (Object)mp);
                    break;
                }
                if (data != null) {
                    this.setJSONContentTypeIfAbsent(builder, headers);
                    response = (ClientResponse)builder.put(ClientResponse.class, (Object)data);
                    break;
                }
                response = (ClientResponse)builder.put(ClientResponse.class);
                break;
            }
            case DELETE: {
                response = (ClientResponse)builder.delete(ClientResponse.class, (Object)data);
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        return CloseableClientResponse.of((ClientResponse)response);
    }

    protected void setJSONContentTypeIfAbsent(WebResource.Builder builder, Map<String, String> headers) {
        if (headers == null || !headers.containsKey("Content-Type")) {
            builder.type("application/json");
        }
    }

    protected JsonNode getResponseAsJson(RequestType responseType, String url) throws IOException, JsonProcessingException {
        return this.getResponseAsJson(responseType, url, null);
    }

    protected JsonNode getResponseAsJson(RequestType responseType, String url, MultivaluedMap<String, String> queryParams) throws JsonProcessingException, IOException {
        try (CloseableClientResponse response = this.getResponse(responseType, url, queryParams);){
            Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
            JsonNode jsonNode = this.mapper.readTree(response.getEntityInputStream());
            return jsonNode;
        }
    }

    protected void fetchInvalidations() {
        this.session.save();
        if (TransactionHelper.isTransactionActiveOrMarkedRollback()) {
            TransactionHelper.commitOrRollbackTransaction();
            TransactionHelper.startTransaction();
        }
    }

    protected void assertNodeEqualsDoc(JsonNode node, DocumentModel note) throws Exception {
        Assert.assertEquals((Object)"document", (Object)node.get("entity-type").asText());
        Assert.assertEquals((Object)note.getPathAsString(), (Object)node.get("path").asText());
        Assert.assertEquals((Object)note.getId(), (Object)node.get("uid").asText());
        Assert.assertEquals((Object)note.getTitle(), (Object)node.get("title").asText());
    }

    protected List<JsonNode> getLogEntries(JsonNode node) {
        Assert.assertEquals((Object)"documents", (Object)node.get("entity-type").asText());
        Assert.assertTrue((boolean)node.get("entries").isArray());
        ArrayList<JsonNode> result = new ArrayList<JsonNode>();
        Iterator elements = node.get("entries").elements();
        while (elements.hasNext()) {
            result.add((JsonNode)elements.next());
        }
        return result;
    }

    protected String getErrorMessage(JsonNode node) {
        Assert.assertEquals((Object)"exception", (Object)node.get("entity-type").asText());
        Assert.assertTrue((boolean)node.get("message").isTextual());
        return node.get("message").asText();
    }

    protected void assertEntityEqualsDoc(InputStream in, DocumentModel doc) throws Exception {
        JsonNode node = this.mapper.readTree(in);
        this.assertNodeEqualsDoc(node, doc);
    }

    protected static enum RequestType {
        GET,
        POST,
        DELETE,
        PUT,
        POSTREQUEST,
        GETES;

    }
}

