/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.test;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Calendar;
import java.util.concurrent.TimeUnit;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.automation.core.util.DocumentHelper;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoGroup;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.test.annotations.RepositoryInit;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.platform.usermanager.exceptions.GroupAlreadyExistsException;
import org.nuxeo.ecm.platform.usermanager.exceptions.UserAlreadyExistsException;
import org.nuxeo.ecm.webengine.JsonFactoryManager;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class RestServerInit
implements RepositoryInit {
    public static final int MAX_NOTE = 5;
    private static final String POWER_USER_LOGIN = "user0";
    public static final String[] FIRSTNAMES = new String[]{"Steve", "John", "Georges", "Bill", "Bill"};
    public static final String[] LASTNAMES = new String[]{"Jobs", "Lennon", "Harrisson", "Gates", "Murray"};
    public static final String[] GROUPNAMES = new String[]{"Stark", "Lannister", "Targaryen", "Greyjoy"};

    public void populate(CoreSession session) {
        DocumentModel doc;
        int i;
        JsonFactoryManager jsonFactoryManager = (JsonFactoryManager)Framework.getService(JsonFactoryManager.class);
        if (!jsonFactoryManager.isStackDisplay()) {
            jsonFactoryManager.toggleStackDisplay();
        }
        for (i = 0; i < 5; ++i) {
            doc = session.createDocumentModel("/", "folder_" + i, "Folder");
            doc.setPropertyValue("dc:title", (Serializable)((Object)("Folder " + i)));
            if (i == 0) {
                Calendar cal = Calendar.getInstance();
                cal.set(1, 2007);
                cal.set(2, 1);
                cal.set(5, 17);
                doc.setPropertyValue("dc:issued", (Serializable)cal);
            }
            Framework.doPrivileged(() -> session.createDocument(doc));
        }
        for (i = 0; i < 5; ++i) {
            doc = session.createDocumentModel("/folder_1", "note_" + i, "Note");
            doc.setPropertyValue("dc:title", (Serializable)((Object)("Note " + i)));
            doc.setPropertyValue("dc:source", (Serializable)((Object)("Source" + i)));
            doc.setPropertyValue("dc:nature", (Serializable)((Object)("Nature" + i % 2)));
            doc.setPropertyValue("dc:coverage", (Serializable)((Object)("Coverage" + i % 3)));
            doc.setPropertyValue("note:note", (Serializable)((Object)("Note " + i)));
            Framework.doPrivileged(() -> session.createDocument(doc));
        }
        DocumentModel doc2 = session.createDocumentModel("/folder_2", "file", "File");
        doc2.setPropertyValue("dc:title", (Serializable)((Object)"File"));
        doc2 = session.createDocument(doc2);
        File fieldAsJsonFile = FileUtils.getResourceFileFromContext((String)"blob.json");
        try {
            Blob fb = Blobs.createBlob((File)fieldAsJsonFile, (String)"image/jpeg");
            DocumentHelper.addBlob((Property)doc2.getProperty("file:content"), (Blob)fb);
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
        session.saveDocument(doc2);
        TransactionHelper.commitOrRollbackTransaction();
        TransactionHelper.startTransaction();
        try {
            ((WorkManager)Framework.getService(WorkManager.class)).awaitCompletion(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException cause) {
            Thread.currentThread().interrupt();
            throw new NuxeoException((Throwable)cause);
        }
        UserManager um = (UserManager)Framework.getService(UserManager.class);
        if (um != null) {
            Framework.doPrivileged(() -> this.createUsersAndGroups(um));
        }
    }

    private void createUsersAndGroups(UserManager um) throws UserAlreadyExistsException, GroupAlreadyExistsException {
        int idx;
        for (idx = 0; idx < 4; ++idx) {
            String groupId = "group" + idx;
            String groupLabel = GROUPNAMES[idx];
            this.createGroup(um, groupId, groupLabel);
        }
        for (idx = 0; idx < 5; ++idx) {
            String userId = "user" + idx;
            String firstName = FIRSTNAMES[idx];
            String lastName = LASTNAMES[idx];
            this.createUser(um, userId, firstName, lastName);
        }
        this.createGroup(um, "powerusers", "Power Users");
        NuxeoPrincipal principal = um.getPrincipal(POWER_USER_LOGIN);
        principal.setGroups(Arrays.asList("powerusers"));
        um.updateUser(principal.getModel());
        this.createGroup(um, "foogroup", "foo group");
        this.createUser(um, "foouser", "Foo", "Foo");
    }

    private void createGroup(UserManager um, String groupId, String groupLabel) throws GroupAlreadyExistsException {
        NuxeoGroup group = um.getGroup(groupId);
        if (group != null) {
            um.deleteGroup(groupId);
        }
        DocumentModel groupModel = um.getBareGroupModel();
        String schemaName = um.getGroupSchemaName();
        groupModel.setProperty(schemaName, "groupname", (Object)groupId);
        groupModel.setProperty(schemaName, "grouplabel", (Object)groupLabel);
        groupModel.setProperty(schemaName, "description", (Object)("description of " + groupId));
        groupModel = um.createGroup(groupModel);
    }

    protected void createUser(UserManager um, String userId, String firstName, String lastName) {
        NuxeoPrincipal principal = um.getPrincipal(userId);
        if (principal != null) {
            um.deleteUser(principal.getModel());
        }
        DocumentModel userModel = um.getBareUserModel();
        String schemaName = um.getUserSchemaName();
        userModel.setProperty(schemaName, "username", (Object)userId);
        userModel.setProperty(schemaName, "firstName", (Object)firstName);
        userModel.setProperty(schemaName, "lastName", (Object)lastName);
        userModel.setProperty(schemaName, "password", (Object)userId);
        um.createUser(userModel);
        principal = um.getPrincipal(userId);
        principal.setGroups(Arrays.asList("group1"));
        um.updateUser(principal.getModel());
    }

    public static DocumentModel getFolder(int index, CoreSession session) {
        return session.getDocument((DocumentRef)new PathRef("/folder_" + index));
    }

    public static DocumentModel getNote(int index, CoreSession session) {
        return session.getDocument((DocumentRef)new PathRef("/folder_1/note_" + index));
    }

    public static DocumentModel getFile(int index, CoreSession session) {
        return session.getDocument((DocumentRef)new PathRef("/folder_2/file"));
    }

    public static NuxeoPrincipal getPowerUser() {
        UserManager um = (UserManager)Framework.getService(UserManager.class);
        return um.getPrincipal(POWER_USER_LOGIN);
    }
}

