/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.test;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import org.codehaus.jackson.JsonGenerator;
import org.nuxeo.ecm.automation.jaxrs.io.documents.JsonDocumentListWriter;
import org.nuxeo.ecm.automation.jaxrs.io.documents.JsonDocumentWriter;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.webengine.JsonFactoryManager;
import org.nuxeo.runtime.api.Framework;

public class JSONDocumentHelper {
    private static final String[] DEFAULT_SCHEMAS = new String[0];

    public static String getDocAsJson(String[] schemas, DocumentModel doc) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        JsonGenerator jg = JSONDocumentHelper.getJsonGenerator(out);
        JsonDocumentWriter.writeDocument((JsonGenerator)jg, (DocumentModel)doc, (String[])DEFAULT_SCHEMAS, null);
        return ((Object)out).toString();
    }

    private static JsonGenerator getJsonGenerator(OutputStream out) throws IOException {
        JsonFactoryManager factoryProvider = (JsonFactoryManager)Framework.getLocalService(JsonFactoryManager.class);
        return factoryProvider.getJsonFactory().createJsonGenerator(out);
    }

    public static String getDocAsJson(DocumentModel doc) throws Exception {
        return JSONDocumentHelper.getDocAsJson(DEFAULT_SCHEMAS, doc);
    }

    public static String getDocsListAsJson(String[] schemas, DocumentModel ... docs) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DocumentModelListImpl docList = new DocumentModelListImpl(Arrays.asList(docs));
        JsonDocumentListWriter.writeDocuments((JsonGenerator)JSONDocumentHelper.getJsonGenerator(out), (List)docList, (String[])schemas, null);
        return ((Object)out).toString();
    }

    public static String getDocsListAsJson(DocumentModel ... docs) throws Exception {
        return JSONDocumentHelper.getDocsListAsJson(DEFAULT_SCHEMAS, docs);
    }
}

