/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.test;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Calendar;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.automation.core.util.DocumentHelper;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.NuxeoGroup;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.storage.sql.RepositoryManagement;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLRepositoryService;
import org.nuxeo.ecm.core.test.annotations.RepositoryInit;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.platform.usermanager.exceptions.GroupAlreadyExistsException;
import org.nuxeo.ecm.platform.usermanager.exceptions.UserAlreadyExistsException;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class RestServerInit
implements RepositoryInit {
    private static final String POWER_USER_LOGIN = "user0";
    public static final String[] FIRSTNAMES = new String[]{"Steve", "John", "Georges", "Bill"};
    public static final String[] LASTNAMES = new String[]{"Jobs", "Lennon", "Harrisson", "Gates"};
    public static final String[] GROUPNAMES = new String[]{"Stark", "Lannister", "Targaryen", "Greyjoy"};

    public void populate(CoreSession session) throws ClientException {
        DocumentModel doc;
        int i;
        for (i = 0; i < 5; ++i) {
            doc = session.createDocumentModel("/", "folder_" + i, "Folder");
            doc.setPropertyValue("dc:title", (Serializable)((Object)("Folder " + i)));
            if (i == 0) {
                Calendar cal = Calendar.getInstance();
                cal.set(1, 2007);
                cal.set(2, 1);
                cal.set(5, 17);
                doc.setPropertyValue("dc:issued", (Serializable)cal);
            }
            doc = session.createDocument(doc);
        }
        for (i = 0; i < 5; ++i) {
            doc = session.createDocumentModel("/folder_1", "note_" + i, "Note");
            doc.setPropertyValue("dc:title", (Serializable)((Object)("Note " + i)));
            doc.setPropertyValue("dc:source", (Serializable)((Object)("Source" + i)));
            doc.setPropertyValue("dc:nature", (Serializable)((Object)("Nature" + i % 2)));
            doc.setPropertyValue("dc:coverage", (Serializable)((Object)("Coverage" + i % 3)));
            doc.setPropertyValue("note:note", (Serializable)((Object)("Note " + i)));
            doc = session.createDocument(doc);
        }
        DocumentModel doc2 = session.createDocumentModel("/folder_2", "file", "File");
        doc2.setPropertyValue("dc:title", (Serializable)((Object)"File"));
        doc2 = session.createDocument(doc2);
        File fieldAsJsonFile = FileUtils.getResourceFileFromContext((String)"blob.json");
        FileBlob fb = new FileBlob(fieldAsJsonFile);
        fb.setMimeType("image/jpeg");
        DocumentHelper.addBlob((Property)doc2.getProperty("file:content"), (Blob)fb);
        session.saveDocument(doc2);
        TransactionHelper.commitOrRollbackTransaction();
        TransactionHelper.startTransaction();
        try {
            ((WorkManager)Framework.getService(WorkManager.class)).awaitCompletion(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException cause) {
            LogFactory.getLog(RestServerInit.class).error((Object)"Cannot initialize the rest api test repo in 10 seconds", (Throwable)cause);
            Thread.currentThread().interrupt();
        }
        UserManager um = (UserManager)Framework.getLocalService(UserManager.class);
        if (um != null) {
            this.createUsersAndGroups(um);
        }
    }

    private void clearRepositoryCaches(String repositoryName) {
        SQLRepositoryService repoService = (SQLRepositoryService)Framework.getService(SQLRepositoryService.class);
        RepositoryManagement repo = repoService.getRepository(repositoryName);
        repo.clearCaches();
    }

    private void createUsersAndGroups(UserManager um) throws ClientException, UserAlreadyExistsException, GroupAlreadyExistsException {
        int idx;
        for (idx = 0; idx < 4; ++idx) {
            String userId = "user" + idx;
            NuxeoPrincipal principal = um.getPrincipal(userId);
            if (principal != null) {
                um.deleteUser(principal.getModel());
            }
            DocumentModel userModel = um.getBareUserModel();
            String schemaName = um.getUserSchemaName();
            userModel.setProperty(schemaName, "username", (Object)userId);
            userModel.setProperty(schemaName, "firstName", (Object)FIRSTNAMES[idx]);
            userModel.setProperty(schemaName, "lastName", (Object)LASTNAMES[idx]);
            userModel.setProperty(schemaName, "password", (Object)userId);
            userModel = um.createUser(userModel);
            principal = um.getPrincipal(userId);
        }
        for (idx = 0; idx < 4; ++idx) {
            String groupId = "group" + idx;
            String groupLabel = GROUPNAMES[idx];
            this.createGroup(um, groupId, groupLabel);
        }
        this.createGroup(um, "powerusers", "Power Users");
        NuxeoPrincipal principal = um.getPrincipal(POWER_USER_LOGIN);
        principal.setGroups(Arrays.asList("powerusers"));
        um.updateUser(principal.getModel());
    }

    private void createGroup(UserManager um, String groupId, String groupLabel) throws ClientException, GroupAlreadyExistsException {
        NuxeoGroup group = um.getGroup(groupId);
        if (group != null) {
            um.deleteGroup(groupId);
        }
        DocumentModel groupModel = um.getBareGroupModel();
        String schemaName = um.getGroupSchemaName();
        groupModel.setProperty(schemaName, "groupname", (Object)groupId);
        groupModel.setProperty(schemaName, "grouplabel", (Object)groupLabel);
        groupModel = um.createGroup(groupModel);
    }

    public static DocumentModel getFolder(int index, CoreSession session) throws ClientException {
        return session.getDocument((DocumentRef)new PathRef("/folder_" + index));
    }

    public static DocumentModel getNote(int index, CoreSession session) throws ClientException {
        return session.getDocument((DocumentRef)new PathRef("/folder_1/note_" + index));
    }

    public static DocumentModel getFile(int index, CoreSession session) throws ClientException {
        return session.getDocument((DocumentRef)new PathRef("/folder_2/file"));
    }

    public static NuxeoPrincipal getPowerUser() throws ClientException {
        UserManager um = (UserManager)Framework.getLocalService(UserManager.class);
        return um.getPrincipal(POWER_USER_LOGIN);
    }
}

