/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.webwidgets.samples;

import java.text.DateFormat;
import java.util.GregorianCalendar;
import javax.ws.rs.GET;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;

@WebObject(type="lastdocuments")
@Produces(value={"text/html"})
public class LastDocuments
extends DefaultObject {
    private static final String QUERY_CREATED_DOCUMENT = "SELECT * FROM Document WHERE ecm:mixinType != 'Folderish' AND ecm:mixinType != 'HiddenInNavigation' AND ecm:isCheckedInVersion = 0 AND ecm:isProxy = 0 AND ecm:currentLifeCycleState != 'deleted' ORDER BY dc:created DESC";

    @GET
    public Object doGet(@QueryParam(value="nb_docs") int nb_docs, @QueryParam(value="path") String path) throws Exception {
        DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3, this.ctx.getLocale());
        CoreSession session = WebEngine.getActiveContext().getCoreSession();
        DocumentModelList results = session.query(QUERY_CREATED_DOCUMENT, nb_docs);
        JSONArray jsArray = new JSONArray();
        JSONObject elem = null;
        GregorianCalendar calendar = null;
        for (DocumentModel doc : results) {
            elem = new JSONObject();
            elem.put((Object)"url", (Object)(path + "/@nxdoc/" + doc.getId()));
            elem.put((Object)"title", (Object)doc.getTitle());
            calendar = (GregorianCalendar)doc.getProperty("dc:created").getValue();
            elem.put((Object)"created", (Object)dateFormat.format(calendar.getTime()));
            elem.put((Object)"creator", (Object)doc.getProperty("dc:creator").getValue());
            jsArray.add((Object)elem);
        }
        return jsArray.toString();
    }
}

