/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.webwidgets.ui;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import net.sf.json.JSONObject;
import org.nuxeo.ecm.webengine.forms.FormData;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.ModuleRoot;
import org.nuxeo.theme.webwidgets.Manager;
import org.nuxeo.theme.webwidgets.WidgetData;
import org.nuxeo.theme.webwidgets.WidgetType;
import org.nuxeo.theme.webwidgets.ui.Editor;
import org.nuxeo.theme.webwidgets.ui.SessionManager;
import org.nuxeo.theme.webwidgets.ui.WidgetEditorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WebObject(type="nxthemes-webwidgets")
@Produces(value={"text/html"})
public class Main
extends ModuleRoot {
    @GET
    @Path(value="webWidgetFactory")
    public Object renderPerspectiveSelector(@QueryParam(value="org.nuxeo.theme.application.path") String path) {
        return this.getTemplate("webWidgetFactory.ftl").arg("widget_categories", Main.getWidgetCategories()).arg("widget_types", Main.getWidgetTypes()).arg("selected_category", (Object)Main.getSelectedWidgetCategory());
    }

    @GET
    @Path(value="get_panel_data")
    public String getPanelData(@QueryParam(value="area") int area, @QueryParam(value="mode") String mode) {
        try {
            return Manager.getPanelData((int)area, (String)mode);
        }
        catch (Exception e) {
            throw new WidgetEditorException(e.getMessage(), e);
        }
    }

    @POST
    @Path(value="add_widget")
    public void addWidget() {
        FormData form = this.ctx.getForm();
        int area = Integer.valueOf(form.getString("area"));
        String widgetName = form.getString("widget_name");
        int order = Integer.valueOf(form.getString("order"));
        Editor.addWidget(area, widgetName, order);
    }

    @POST
    @Path(value="move_widget")
    public String moveWidget() {
        FormData form = this.ctx.getForm();
        int srcArea = Integer.valueOf(form.getString("src_area"));
        String srcUid = form.getString("src_uid");
        int destArea = Integer.valueOf(form.getString("dest_area"));
        int destOrder = Integer.valueOf(form.getString("dest_order"));
        return Editor.moveWidget(srcArea, srcUid, destArea, destOrder);
    }

    @POST
    @Path(value="remove_widget")
    public void removeWidget() {
        FormData form = this.ctx.getForm();
        String providerName = form.getString("provider");
        String widgetUid = form.getString("widget_uid");
        Editor.removeWidget(providerName, widgetUid);
    }

    @POST
    @Path(value="set_widget_state")
    public void setWidgetState() {
        FormData form = this.ctx.getForm();
        String providerName = form.getString("provider");
        String widgetUid = form.getString("widget_uid");
        String state = form.getString("state");
        Editor.setWidgetState(providerName, widgetUid, state);
    }

    @POST
    @Path(value="set_widget_category")
    public void setWidgetCategory() {
        FormData form = this.ctx.getForm();
        String category = form.getString("category");
        SessionManager.setWidgetCategory(category);
    }

    @GET
    @Path(value="get_widget_data_info")
    public String getWidgetDataInfo(@QueryParam(value="provider") String providerName, @QueryParam(value="widget_uid") String widgetUid, @QueryParam(value="name") String dataName) {
        try {
            return Manager.getWidgetDataInfo((String)providerName, (String)widgetUid, (String)dataName);
        }
        catch (Exception e) {
            throw new WidgetEditorException(e.getMessage(), e);
        }
    }

    @POST
    @Path(value="upload_file")
    public String uploadFile(@QueryParam(value="provider") String providerName, @QueryParam(value="widget_uid") String widgetUid, @QueryParam(value="data") String dataName) {
        HttpServletRequest req = this.ctx.getRequest();
        String res = Editor.uploadFile(req, providerName, widgetUid, dataName);
        long timestamp = new Date().getTime();
        String dataUrl = String.format("nxwebwidgets://data/%s/%s/%s/%s", providerName, widgetUid, dataName, timestamp);
        Editor.setWidgetPreference(providerName, widgetUid, dataName, dataUrl);
        return res;
    }

    @GET
    @Path(value="render_widget_data")
    public Response renderWidgetData(@QueryParam(value="widget_uid") String widgetUid, @QueryParam(value="data") String dataName, @QueryParam(value="provider") String providerName, @QueryParam(value="timestamp") String timestamp) {
        HttpServletRequest request = this.ctx.getRequest();
        String etag = request.getHeader("If-None-Match");
        if (timestamp.equals(etag)) {
            return Response.notModified().build();
        }
        WidgetData data = null;
        try {
            data = Manager.getWidgetData((String)providerName, (String)widgetUid, (String)dataName);
        }
        catch (Exception e) {
            throw new WidgetEditorException(e.getMessage(), e);
        }
        Response.ResponseBuilder builder = Response.ok((Object)data.getContent());
        builder.tag(timestamp);
        builder.type(data.getContentType());
        return builder.build();
    }

    @POST
    @Path(value="update_widget_preferences")
    public void updateWidgetPreferences() {
        FormData form = this.ctx.getForm();
        String providerName = form.getString("provider");
        String widgetUid = form.getString("widget_uid");
        String preferences_map = form.getString("preferences");
        JSONObject preferencesMap = JSONObject.fromObject((Object)preferences_map);
        Editor.updateWidgetPreferences(providerName, widgetUid, (Map<String, String>)preferencesMap);
    }

    @GET
    @Path(value="render_widget_icon")
    public Response renderWidgetIcon(@QueryParam(value="name") String widgetTypeName) {
        byte[] content = Manager.getWidgetIconContent((String)widgetTypeName);
        Response.ResponseBuilder builder = Response.ok((Object)content);
        CacheControl cc = new CacheControl();
        cc.setMaxAge(86400);
        builder.cacheControl(cc);
        return builder.build();
    }

    public static String getSelectedWidgetCategory() {
        String category = SessionManager.getWidgetCategory();
        if (category == null) {
            category = "";
        }
        return category;
    }

    public static Set<String> getWidgetCategories() {
        return Manager.getService().getWidgetCategories();
    }

    public static List<WidgetType> getWidgetTypes() {
        String widgetCategory = Main.getSelectedWidgetCategory();
        return Manager.getService().getWidgetTypes(widgetCategory);
    }
}

