/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.http.client.authentication;

import com.noelios.restlet.util.Base64;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortalSSOAuthenticationProvider {
    private static final String TOKEN_SEP = ":";
    private static final String TS_HEADER = "NX_TS";
    private static final String RANDOM_HEADER = "NX_RD";
    private static final String TOKEN_HEADER = "NX_TOKEN";
    private static final String USER_HEADER = "NX_USER";

    public static Map<String, String> getHeaders(String secretKey, String userName) {
        byte[] hashedToken;
        HashMap<String, String> headers = new HashMap<String, String>();
        Date timestamp = new Date();
        int randomData = new Random(timestamp.getTime()).nextInt();
        String clearToken = timestamp.getTime() + TOKEN_SEP + randomData + TOKEN_SEP + secretKey + TOKEN_SEP + userName;
        try {
            hashedToken = MessageDigest.getInstance("MD5").digest(clearToken.getBytes());
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        String base64HashedToken = Base64.encodeBytes((byte[])hashedToken);
        headers.put(TS_HEADER, String.valueOf(timestamp.getTime()));
        headers.put(RANDOM_HEADER, String.valueOf(randomData));
        headers.put(TOKEN_HEADER, base64HashedToken);
        headers.put(USER_HEADER, userName);
        return headers;
    }
}

