/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.launcher;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.artofsolving.jodconverter.process.MacProcessManager;
import org.artofsolving.jodconverter.process.ProcessManager;
import org.artofsolving.jodconverter.process.PureJavaProcessManager;
import org.artofsolving.jodconverter.process.UnixProcessManager;
import org.artofsolving.jodconverter.process.WindowsProcessManager;
import org.artofsolving.jodconverter.util.PlatformUtils;
import org.nuxeo.launcher.NuxeoJBossLauncher;
import org.nuxeo.launcher.NuxeoJettyLauncher;
import org.nuxeo.launcher.NuxeoTomcatLauncher;
import org.nuxeo.launcher.config.ConfigurationException;
import org.nuxeo.launcher.config.ConfigurationGenerator;
import org.nuxeo.launcher.daemon.DaemonThreadFactory;
import org.nuxeo.launcher.gui.NuxeoLauncherGUI;

public abstract class NuxeoLauncher {
    static final Log log = LogFactory.getLog(NuxeoLauncher.class);
    public static final long DEFAULT_RETRY_TIMEOUT = 120000L;
    public static final long DEFAULT_RETRY_INTERVAL = 250L;
    private static final String JAVA_OPTS_PROPERTY = "launcher.java.opts";
    private static final String JAVA_OPTS_DEFAULT = "-Xms512m -Xmx1024m -XX:MaxPermSize=512m";
    private static final String OVERRIDE_JAVA_TMPDIR_PARAM = "launcher.override.java.tmpdir";
    protected boolean overrideJavaTmpDir;
    private static final String START_MAX_WAIT_PARAM = "launcher.start.max.wait";
    private static final String START_MAX_WAIT_DEFAULT = "300";
    private static final String START_MAX_WAIT_JBOSS_DEFAULT = "900";
    private static final int STOP_MAX_WAIT = 10;
    private static final int STOP_NB_TRY = 5;
    private static final int STOP_SECONDS_BEFORE_NEXT_TRY = 2;
    private static final int MAX_WAIT_LOGFILE = 10;
    private static final String PARAM_NUXEO_URL = "nuxeo.url";
    protected ConfigurationGenerator configurationGenerator;
    protected ProcessManager processManager;
    protected Process nuxeoProcess;
    private String processRegex;
    protected String pid;
    private ExecutorService executor = Executors.newSingleThreadExecutor(new DaemonThreadFactory("NuxeoProcessThread", false));
    private ShutdownThread shutdownHook;
    protected String[] params;
    protected String command;
    private boolean useGui = false;
    private boolean reloadConfiguration = false;

    public final ConfigurationGenerator getConfigurationGenerator() {
        return this.configurationGenerator;
    }

    public String getCommand() {
        return this.command;
    }

    public NuxeoLauncher(ConfigurationGenerator configurationGenerator) {
        this.configurationGenerator = configurationGenerator;
        this.processManager = this.getOSProcessManager();
        this.processRegex = Pattern.quote(configurationGenerator.getNuxeoConf().getPath()) + ".*" + Pattern.quote(this.getServerPrint());
    }

    private ProcessManager getOSProcessManager() {
        if (PlatformUtils.isLinux()) {
            UnixProcessManager unixProcessManager = new UnixProcessManager();
            return unixProcessManager;
        }
        if (PlatformUtils.isMac()) {
            return new MacProcessManager();
        }
        if (PlatformUtils.isWindows()) {
            WindowsProcessManager windowsProcessManager = new WindowsProcessManager();
            return windowsProcessManager.isUsable() ? windowsProcessManager : new PureJavaProcessManager();
        }
        return new PureJavaProcessManager();
    }

    protected void start(boolean logProcessOutput) throws IOException, InterruptedException {
        ArrayList<String> startCommand = new ArrayList<String>();
        startCommand.add(this.getJavaExecutable().getPath());
        startCommand.addAll(Arrays.asList(this.getJavaOptsProperty().split(" ")));
        startCommand.add("-cp");
        startCommand.add(this.getClassPath());
        startCommand.addAll(this.getNuxeoProperties());
        startCommand.addAll(this.getServerProperties());
        this.setServerStartCommand(startCommand);
        for (String param : this.params) {
            startCommand.add(param);
        }
        ProcessBuilder pb = new ProcessBuilder(this.getOSCommand(startCommand));
        pb.directory(this.configurationGenerator.getNuxeoHome());
        log.debug((Object)("Server command: " + pb.command()));
        this.nuxeoProcess = pb.start();
        this.logProcessStreams(pb, this.nuxeoProcess, logProcessOutput);
        Thread.sleep(1000L);
        if (this.getPid() != null) {
            log.info((Object)("Server started with process ID " + this.pid + "."));
        } else {
            log.info((Object)"Sent server start command but could not get process ID.");
        }
    }

    protected String getJavaOptsProperty() {
        String[] properties;
        String ret = System.getProperty(JAVA_OPTS_PROPERTY, JAVA_OPTS_DEFAULT);
        for (String property : properties = new String[]{"nuxeo.home.dir", "nuxeo.log.dir", "nuxeo.data.dir", "nuxeo.tmp.dir"}) {
            String value = this.configurationGenerator.getUserConfig().getProperty(property);
            if (value == null || value.isEmpty()) continue;
            ret = ret.replace("${" + property + "}", value);
        }
        return ret;
    }

    public void checkNoRunningServer() throws IllegalThreadStateException {
        try {
            String existingPid = this.getPid();
            if (existingPid != null) {
                throw new IllegalStateException("A server is already running with process ID " + existingPid);
            }
        }
        catch (IOException e) {
            log.warn((Object)("Could not check existing process" + e.getMessage()));
        }
    }

    public void logProcessStreams(ProcessBuilder pb, Process process, boolean logProcessOutput) {
        new ThreadedStreamGobbler(process.getInputStream(), logProcessOutput ? 3 : 7).start();
        new ThreadedStreamGobbler(process.getErrorStream(), logProcessOutput ? 5 : 7).start();
    }

    protected abstract String getServerPrint();

    private List<String> getOSCommand(List<String> roughCommand) {
        String linearizedCommand = new String();
        ArrayList<String> osCommand = new ArrayList<String>();
        if (PlatformUtils.isLinux() || PlatformUtils.isMac()) {
            for (String commandToken : roughCommand) {
                if (commandToken.contains(" ")) {
                    commandToken = commandToken.replaceAll(" ", "\\\\ ");
                }
                linearizedCommand = linearizedCommand + " " + commandToken;
            }
            osCommand.add("/bin/sh");
            osCommand.add("-c");
            osCommand.add(linearizedCommand);
            return osCommand;
        }
        if (PlatformUtils.isWindows()) {
            return roughCommand;
        }
        return roughCommand;
    }

    protected abstract Collection<? extends String> getServerProperties();

    protected abstract void setServerStartCommand(List<String> var1);

    private File getJavaExecutable() {
        File javaExec = new File(System.getProperty("java.home"), "bin" + File.separator + "java");
        return javaExec;
    }

    protected abstract String getClassPath();

    protected Collection<? extends String> getNuxeoProperties() {
        ArrayList<String> nuxeoProperties = new ArrayList<String>();
        nuxeoProperties.add("-Dnuxeo.home=" + this.configurationGenerator.getNuxeoHome().getPath());
        nuxeoProperties.add("-Dnuxeo.conf=" + this.configurationGenerator.getNuxeoConf().getPath());
        nuxeoProperties.add(this.getNuxeoProperty("nuxeo.log.dir"));
        nuxeoProperties.add(this.getNuxeoProperty("nuxeo.data.dir"));
        nuxeoProperties.add(this.getNuxeoProperty("nuxeo.tmp.dir"));
        if (this.overrideJavaTmpDir) {
            nuxeoProperties.add("-Djava.io.tmpdir=" + this.configurationGenerator.getUserConfig().getProperty("nuxeo.tmp.dir"));
        }
        return nuxeoProperties;
    }

    private String getNuxeoProperty(String property) {
        return "-D" + property + "=" + this.configurationGenerator.getUserConfig().getProperty(property);
    }

    protected String addToClassPath(String cp, String filename) {
        File classPathEntry = new File(this.configurationGenerator.getNuxeoHome(), filename);
        if (!classPathEntry.exists()) {
            throw new RuntimeException("Tried to add inexistent classpath entry: " + classPathEntry);
        }
        cp = cp + System.getProperty("path.separator") + classPathEntry.getPath();
        return cp;
    }

    public static void main(String[] args) throws ConfigurationException {
        if (args.length == 0) {
            NuxeoLauncher.printHelp();
            return;
        }
        final NuxeoLauncher launcher = NuxeoLauncher.createLauncher(args);
        NuxeoLauncherGUI launcherGUI = null;
        String command = launcher.command;
        boolean commandSucceeded = true;
        if (launcher.useGui) {
            launcherGUI = new NuxeoLauncherGUI(launcher);
            command = launcherGUI.execute();
        }
        if (command == null) {
            return;
        }
        if ("help".equalsIgnoreCase(command)) {
            NuxeoLauncher.printHelp();
        } else if ("status".equalsIgnoreCase(command)) {
            log.info((Object)launcher.status());
        } else if ("startbg".equalsIgnoreCase(command)) {
            commandSucceeded = launcher.doStart();
        } else if ("start".equalsIgnoreCase(command)) {
            commandSucceeded = launcher.doStartAndWait();
        } else if ("console".equalsIgnoreCase(command)) {
            launcher.executor.execute(new Runnable(){

                @Override
                public void run() {
                    launcher.addShutdownHook();
                    if (!launcher.doStart(true)) {
                        launcher.removeShutdownHook();
                        System.exit(1);
                    }
                }
            });
        } else if ("stop".equalsIgnoreCase(command)) {
            launcher.stop();
        } else if ("restartbg".equalsIgnoreCase(command)) {
            launcher.stop();
            commandSucceeded = launcher.doStart();
        } else if ("restart".equalsIgnoreCase(command)) {
            launcher.stop();
            commandSucceeded = launcher.doStartAndWait();
        } else if ("configure".equalsIgnoreCase(command)) {
            try {
                launcher.configure();
            }
            catch (ConfigurationException e) {
                log.error((Object)e);
                commandSucceeded = false;
            }
        } else {
            if ("pack".equalsIgnoreCase(command)) {
                throw new UnsupportedOperationException();
            }
            NuxeoLauncher.printHelp();
            commandSucceeded = false;
        }
        if (launcher.useGui) {
            launcherGUI.updateServerStatus();
        }
        if (!commandSucceeded) {
            System.exit(1);
        }
    }

    public boolean doStartAndWait() {
        return this.doStartAndWait(false);
    }

    public void stop() {
        this.stop(false);
    }

    public boolean doStart() {
        return this.doStart(false);
    }

    public boolean doStartAndWait(boolean logProcessOutput) {
        boolean commandSucceeded = true;
        if (this.doStart(logProcessOutput)) {
            this.addShutdownHook();
            if (!this.configurationGenerator.isWizardRequired() && !this.waitForEffectiveStart()) {
                commandSucceeded = false;
                this.removeShutdownHook();
                this.stop(logProcessOutput);
            } else {
                this.removeShutdownHook();
            }
        } else {
            commandSucceeded = false;
        }
        return commandSucceeded;
    }

    protected void removeShutdownHook() {
        log.debug((Object)"Remove shutdown hook");
        try {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    /*
     * Exception decompiling
     */
    protected boolean waitForEffectiveStart() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean doStart(boolean logProcessOutput) {
        boolean serverStarted = false;
        try {
            if (this.reloadConfiguration) {
                this.configurationGenerator = new ConfigurationGenerator();
                this.configurationGenerator.init();
            } else {
                this.reloadConfiguration = true;
            }
            this.checkNoRunningServer();
            this.configure();
            if (this.configurationGenerator.isWizardRequired()) {
                if (!this.configurationGenerator.isForceGeneration()) {
                    log.error((Object)"Cannot start setup wizard with nuxeo.force.generation=false. Either set it to true or once, either set nuxeo.wizard.done=true to skip the wizard.");
                    return false;
                }
                String paramsStr = "";
                for (String param : this.params) {
                    paramsStr = paramsStr + " " + param;
                }
                System.setProperty("wizard.restart.params", paramsStr);
                this.configurationGenerator.prepareWizardStart();
            } else {
                this.configurationGenerator.cleanupPostWizard();
            }
            this.start(logProcessOutput);
            serverStarted = this.isRunning();
            if (this.pid != null) {
                File pidFile = new File(this.configurationGenerator.getPidDir(), "nuxeo.pid");
                FileWriter writer = new FileWriter(pidFile);
                writer.write(this.pid);
                writer.close();
            }
        }
        catch (ConfigurationException e) {
            log.error((Object)"Could not run configuration", (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)"Could not start process", (Throwable)e);
        }
        catch (InterruptedException e) {
            log.error((Object)"Could not start process", (Throwable)e);
        }
        catch (IllegalStateException e) {
            log.error((Object)e.getMessage());
        }
        catch (IllegalThreadStateException e) {
            log.error((Object)e.getMessage());
        }
        return serverStarted;
    }

    protected void addShutdownHook() {
        log.debug((Object)"Add shutdown hook");
        this.shutdownHook = new ShutdownThread(this);
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    public void stop(boolean logProcessOutput) {
        try {
            if (!(this.processManager instanceof PureJavaProcessManager) && this.getPid() == null) {
                log.info((Object)"Server is not running.");
                return;
            }
            System.out.print("Stopping server...");
            int nbTry = 0;
            boolean retry = false;
            do {
                ArrayList<String> stopCommand = new ArrayList<String>();
                stopCommand.add(this.getJavaExecutable().getPath());
                stopCommand.add("-cp");
                stopCommand.add(this.getClassPath());
                stopCommand.addAll(this.getNuxeoProperties());
                stopCommand.addAll(this.getServerProperties());
                this.setServerStopCommand(stopCommand);
                for (String param : this.params) {
                    stopCommand.add(param);
                }
                ProcessBuilder pb = new ProcessBuilder(this.getOSCommand(stopCommand));
                pb.directory(this.configurationGenerator.getNuxeoHome());
                log.debug((Object)("Server command: " + pb.command()));
                try {
                    Process stopProcess = pb.start();
                    this.logProcessStreams(pb, stopProcess, logProcessOutput);
                    stopProcess.waitFor();
                    boolean wait = true;
                    while (wait) {
                        try {
                            if (stopProcess.exitValue() == 0) {
                                retry = false;
                            } else {
                                retry = ++nbTry < 5;
                                System.out.print(".");
                                Thread.sleep(2000L);
                            }
                            wait = false;
                        }
                        catch (IllegalThreadStateException e) {
                            wait = true;
                            System.out.print(".");
                            Thread.sleep(1000L);
                        }
                    }
                    if (this.processManager instanceof PureJavaProcessManager) {
                        log.info((Object)"Can't check server status on your OS.");
                        return;
                    }
                    for (int i = 0; !retry && this.getPid() != null && i < 10; ++i) {
                        System.out.print(".");
                        Thread.sleep(1000L);
                    }
                }
                catch (InterruptedException e) {
                    log.error((Object)e);
                }
            } while (retry);
            if (this.getPid() == null) {
                log.info((Object)"Server stopped.");
            } else {
                log.info((Object)("No answer from server, try to kill process " + this.pid + "..."));
                this.processManager.kill(this.nuxeoProcess, this.pid);
                if (this.getPid() == null) {
                    log.info((Object)"Server forcibly stopped.");
                }
            }
        }
        catch (IOException e) {
            log.error((Object)"Could not manage process!", (Throwable)e);
        }
    }

    protected abstract void setServerStopCommand(List<String> var1);

    private String getPid() throws IOException {
        this.pid = this.processManager.findPid(this.processRegex);
        return this.pid;
    }

    public void configure() throws ConfigurationException {
        this.configurationGenerator.verifyInstallation();
        this.configurationGenerator.run();
        this.overrideJavaTmpDir = Boolean.parseBoolean(this.configurationGenerator.getUserConfig().getProperty(OVERRIDE_JAVA_TMPDIR_PARAM, "true"));
    }

    private String getDefaultMaxWait() {
        return this.configurationGenerator.isJBoss ? START_MAX_WAIT_JBOSS_DEFAULT : START_MAX_WAIT_DEFAULT;
    }

    public String status() {
        if (this.processManager instanceof PureJavaProcessManager) {
            return "Can't check server status on your OS.";
        }
        try {
            if (this.getPid() == null) {
                return "Server is not running.";
            }
            return "Server is running with process ID " + this.getPid() + ".";
        }
        catch (IOException e) {
            return "Could not check existing process (" + e.getMessage() + ").";
        }
    }

    private static NuxeoLauncher createLauncher(String[] args) throws ConfigurationException {
        NuxeoLauncher launcher;
        ConfigurationGenerator configurationGenerator = new ConfigurationGenerator();
        if (configurationGenerator.isJBoss) {
            launcher = new NuxeoJBossLauncher(configurationGenerator);
        } else if (configurationGenerator.isJetty) {
            launcher = new NuxeoJettyLauncher(configurationGenerator);
        } else if (configurationGenerator.isTomcat) {
            launcher = new NuxeoTomcatLauncher(configurationGenerator);
        } else {
            throw new ConfigurationException("Unknown server !");
        }
        super.setArgs(args);
        configurationGenerator.init();
        return launcher;
    }

    private void setArgs(String[] args) {
        this.command = args[0];
        int firstParamToKeep = 1;
        if ("gui".equalsIgnoreCase(this.command)) {
            this.useGui = true;
            this.command = args.length > 1 ? args[1] : null;
            firstParamToKeep = 2;
        }
        this.params = firstParamToKeep > args.length ? new String[]{} : Arrays.copyOfRange(args, firstParamToKeep, args.length);
    }

    public static void printHelp() {
        log.error((Object)"\nnuxeoctl usage:\n\tnuxeoctl [gui|nogui] (help|start|stop|restart|configure|console|status|startbg|restartbg|pack) [additional parameters]");
        log.error((Object)"\njava usage:\n\tjava [-Dlauncher.java.opts=\"JVM options\"] [-Dnuxeo.home=\"/path/to/nuxeo\"] [-Dnuxeo.conf=\"/path/to/nuxeo.conf\"] [-Djvmcheck=nofail] -jar \"path/to/nuxeo-launcher.jar\" \\ \n\t\t[gui] (help|start|stop|restart|configure|console|status|startbg|restartbg|pack) [additional parameters]");
        log.error((Object)"\n\t Options:");
        log.error((Object)"\t\t launcher.java.opts\tParameters for the server JVM (default are -Xms512m -Xmx1024m -XX:MaxPermSize=512m).");
        log.error((Object)"\t\t nuxeo.home\t\tNuxeo server root path (default is parent of called script).");
        log.error((Object)"\t\t nuxeo.conf\t\tPath to nuxeo.conf file (default is $NUXEO_HOME/bin/nuxeo.conf).");
        log.error((Object)"\t\t jvmcheck\t\tWill continue execution if equals to \"nofail\", else will exit.");
        log.error((Object)"\t\t gui\t\t\tLauncher with a graphical user interface (default is headless/console mode).");
        log.error((Object)"\t\t nogui\t\t\tWindows only. Deactivate gui option which is set by default under Windows.");
        log.error((Object)"\n\t Commands:");
        log.error((Object)"\t\t help\t\tPrint this message.");
        log.error((Object)"\t\t start\t\tStart Nuxeo server in background, waiting for effective start. Useful for batch executions requiring the server being immediatly available after the script returned.");
        log.error((Object)"\t\t stop\t\tStop any Nuxeo server started with the same nuxeo.conf file.");
        log.error((Object)"\t\t restart\tRestart Nuxeo server.");
        log.error((Object)"\t\t configure\tConfigure Nuxeo server with parameters from nuxeo.conf.");
        log.error((Object)"\t\t console\tStart Nuxeo server in a console mode. Ctrl-C will stop it.");
        log.error((Object)"\t\t status\t\tPrint server status (running or not).");
        log.error((Object)"\t\t startbg\tStart Nuxeo server in background, without waiting for effective start. Useful for starting Nuxeo as a service.");
        log.error((Object)"\t\t restartbg\tRestart Nuxeo server with a call to \"startbg\" after \"stop\".");
        log.error((Object)"\t\t pack\t\tNot implemented. Use \"pack\" Shell script.");
        log.error((Object)"\n\t Additional parameters: All parameters following a command are passed to the java process when executing the command.");
    }

    public boolean isRunning() {
        if (this.nuxeoProcess == null) {
            try {
                return this.getPid() != null;
            }
            catch (IOException e) {
                log.error((Object)e);
                return false;
            }
        }
        try {
            this.nuxeoProcess.exitValue();
            return false;
        }
        catch (IllegalThreadStateException exception) {
            return true;
        }
    }

    public File getLogFile() {
        return new File(this.configurationGenerator.getLogDir(), "server.log");
    }

    public String getURL() {
        return this.configurationGenerator.getUserConfig().getProperty(PARAM_NUXEO_URL);
    }

    protected class ShutdownThread
    extends Thread {
        private NuxeoLauncher launcher;

        public ShutdownThread(NuxeoLauncher launcher) {
            this.launcher = launcher;
        }

        @Override
        public void run() {
            log.debug((Object)"Shutting down...");
            this.launcher.stop();
            log.debug((Object)"Shutdown complete.");
        }
    }

    protected class ThreadedStreamGobbler
    extends Thread {
        private InputStream is;
        private int logLevel;

        ThreadedStreamGobbler(InputStream is, int logLevel) {
            this.is = is;
            this.logLevel = logLevel;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BufferedReader br = new BufferedReader(new InputStreamReader(this.is));
            try {
                String line;
                block9: while ((line = br.readLine()) != null) {
                    switch (this.logLevel) {
                        case 3: {
                            log.info((Object)line);
                            continue block9;
                        }
                        case 5: {
                            log.error((Object)line);
                            continue block9;
                        }
                    }
                }
            }
            catch (IOException e) {
                log.error((Object)e);
            }
            finally {
                IOUtils.closeQuietly((Reader)br);
            }
        }
    }
}

