/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.jboss.deployment;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.deployment.EARDeployer;
import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.system.ServiceControllerMBean;
import org.nuxeo.common.collections.DependencyTree;
import org.nuxeo.runtime.jboss.deployment.NuxeoDeployerMBean;
import org.nuxeo.runtime.jboss.deployment.preprocessor.ContainerDescriptor;
import org.nuxeo.runtime.jboss.deployment.preprocessor.DeploymentPreprocessor;
import org.nuxeo.runtime.jboss.deployment.preprocessor.FragmentDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NuxeoDeployer
extends EARDeployer
implements NuxeoDeployerMBean {
    public static final String LIB_DIR = "lib";
    public static final String CONFIG_DIR = "config";
    public static final String DS_DIR = "datasources";
    public static final String MBEANS_DIR = "config/mbeans";
    private static final String[] DEFAULT_ENHANCED_SUFFIXES = new String[]{"650:.ear", "850:.nxar", "850:.nxp", "850:.nux", "850:.ecm"};
    protected final ServiceControllerMBean controller;
    private DeploymentPreprocessor processor;
    private boolean debug = true;
    private List<DeploymentInfo> subDeployments;

    public NuxeoDeployer() {
        this.setEnhancedSuffixes(DEFAULT_ENHANCED_SUFFIXES);
        this.controller = (ServiceControllerMBean)MBeanProxyExt.create(ServiceControllerMBean.class, (ObjectName)ServiceControllerMBean.OBJECT_NAME, (MBeanServer)MBeanServerLocator.locateJBoss());
    }

    @Override
    public void setDebug(boolean value) {
        this.debug = value;
    }

    @Override
    public boolean isDebug() {
        return this.debug;
    }

    @Override
    public void redeploy(String shortName) throws DeploymentException {
        shortName = '/' + shortName;
        for (DeploymentInfo deployment : this.subDeployments) {
            if (!deployment.shortName.equals(shortName)) continue;
            this.mainDeployer.redeploy(deployment);
            return;
        }
        throw new DeploymentException("Deployment not found: " + shortName);
    }

    @Override
    public String listDeployments() {
        StringBuffer buf = new StringBuffer();
        for (DeploymentInfo deployment : this.subDeployments) {
            buf.append(deployment.shortName).append("\r\n");
        }
        return buf.toString();
    }

    @Override
    public String[] getDeployments() {
        DeploymentInfo[] dinfos = this.subDeployments.toArray(new DeploymentInfo[this.subDeployments.size()]);
        String[] result = new String[dinfos.length];
        for (int i = 0; i < dinfos.length; ++i) {
            result[i] = dinfos[i].shortName;
        }
        return result;
    }

    public boolean accepts(DeploymentInfo sdi) {
        if (super.accepts(sdi)) {
            if (sdi.isDirectory && NuxeoDeployer.hasContainerDescriptor(sdi) && this.isPreprocessingEnabled(sdi)) {
                sdi.context.put("EAR_PREPROCESSING", Boolean.TRUE);
            }
            return true;
        }
        return false;
    }

    public void init(DeploymentInfo di) throws DeploymentException {
        if (!NuxeoDeployer.canPreprocess(di)) {
            super.init(di);
            return;
        }
        try {
            String url = di.localUrl.toString();
            url = url.replace(" ", "%20");
            File directory = new File(new URI(url));
            this.processor = new DeploymentPreprocessor(directory);
            this.processor.init();
            this.processor.predeploy();
            super.init(di);
            Collection<String> firstDeployments = this.processStaticLibraries(di);
            Collection<String> mbeansDeployments = this.processNestedMBeans(di);
            firstDeployments.addAll(mbeansDeployments);
            Collection<String> dsDeployments = this.processNestedDataSources(di);
            firstDeployments.addAll(dsDeployments);
            Collection<String> lastDeployments = this.processConfig(di);
            this._processNestedDeployments(di);
            ContainerDescriptor root = this.processor.getRootContainer();
            if (root != null) {
                this.log.info((Object)"Applying sub-deployments ordering workaround");
                this.subDeployments = new ArrayList<DeploymentInfo>(di.subDeployments);
                di.subDeployments.clear();
                DeploymentSorter sorter = new DeploymentSorter(root);
                sorter.addFirst(firstDeployments);
                sorter.addLast(lastDeployments);
                Collections.sort(this.subDeployments, sorter);
                if (this.log.isInfoEnabled()) {
                    StringBuffer logBuf = new StringBuffer("Sub Deployment order is: \n");
                    for (DeploymentInfo deploymentInfo : this.subDeployments) {
                        logBuf.append(deploymentInfo.shortName).append('\n');
                    }
                    this.log.info((Object)logBuf.toString());
                    logBuf.setLength(0);
                    logBuf.append("Unresolved Sub Deployments: \n");
                    for (DependencyTree.Entry entry : root.fragments.getPendingEntries()) {
                        logBuf.append((String)entry.getKey()).append(" : ").append(entry.getWaitsFor()).append("\n");
                    }
                    this.log.info((Object)logBuf.toString());
                }
            }
        }
        catch (URISyntaxException e) {
            throw new DeploymentException("Failed to get deployment directory for " + di.shortName, (Throwable)e);
        }
        catch (Exception e) {
            throw new DeploymentException("Deployment preprocessing failed for " + di.shortName, (Throwable)e);
        }
    }

    public void start(DeploymentInfo di) throws DeploymentException {
        if (!NuxeoDeployer.canPreprocess(di)) {
            super.start(di);
            return;
        }
        if (this.subDeployments != null) {
            for (DeploymentInfo sub : this.subDeployments) {
                this.mainDeployer.deploy(sub);
            }
        }
        super.start(di);
        NuxeoDeployer.writeStatusFile(di);
    }

    public void stop(DeploymentInfo di) throws DeploymentException {
        if (!NuxeoDeployer.canPreprocess(di)) {
            super.stop(di);
            return;
        }
        super.stop(di);
        if (this.subDeployments != null) {
            for (DeploymentInfo sub : this.subDeployments) {
                this.mainDeployer.undeploy(sub);
            }
        }
    }

    protected Collection<String> processNestedDataSources(DeploymentInfo di) throws DeploymentException {
        ArrayList<String> names = new ArrayList<String>();
        File directory = new File(NuxeoDeployer.getEarDirectory(di), DS_DIR);
        if (!directory.isDirectory()) {
            return names;
        }
        for (String fileName : directory.list()) {
            try {
                if (!fileName.endsWith("-ds.xml")) continue;
                this.log.info((Object)("Found DataSource subdeployment: " + fileName));
                new DeploymentInfo(new URL(di.url, "datasources/" + fileName), di, this.getServer());
                names.add(fileName);
            }
            catch (Exception e) {
                this.log.error((Object)("Failed to create subdeployment for " + fileName), (Throwable)e);
            }
        }
        return names;
    }

    protected Collection<String> processNestedMBeans(DeploymentInfo di) throws DeploymentException {
        ArrayList<String> names = new ArrayList<String>();
        File directory = new File(NuxeoDeployer.getEarDirectory(di), MBEANS_DIR);
        if (!directory.isDirectory()) {
            return names;
        }
        for (String fileName : directory.list()) {
            try {
                if (!fileName.endsWith("-service.xml")) continue;
                this.log.info((Object)("Found DataSource subdeployment: " + fileName));
                new DeploymentInfo(new URL(di.url, "config/mbeans/" + fileName), di, this.getServer());
                names.add(fileName);
            }
            catch (Exception e) {
                this.log.error((Object)("Failed to create subdeployment for " + fileName), (Throwable)e);
            }
        }
        return names;
    }

    protected Collection<String> processStaticLibraries(DeploymentInfo di) throws DeploymentException {
        ArrayList<String> names = new ArrayList<String>();
        File directory = new File(NuxeoDeployer.getEarDirectory(di), LIB_DIR);
        if (!directory.isDirectory()) {
            return names;
        }
        for (String fileName : directory.list()) {
            try {
                if (!fileName.endsWith(".jar")) continue;
                this.log.info((Object)("Found library: " + fileName));
                new DeploymentInfo(new URL(di.url, "lib/" + fileName), di, this.getServer());
                names.add(fileName);
            }
            catch (Exception e) {
                this.log.error((Object)("Failed to create subdeployment for " + fileName), (Throwable)e);
            }
        }
        return names;
    }

    protected Collection<String> processConfig(DeploymentInfo di) throws DeploymentException {
        ArrayList<String> names = new ArrayList<String>();
        File directory = new File(NuxeoDeployer.getEarDirectory(di), CONFIG_DIR);
        if (!directory.isDirectory()) {
            return names;
        }
        for (String fileName : directory.list()) {
            try {
                if (!fileName.endsWith("-config.xml") && !fileName.endsWith("-bundle.xml")) continue;
                this.log.info((Object)("Found deployable configuration: " + fileName));
                new DeploymentInfo(new URL(di.url, "config/" + fileName), di, this.getServer());
                names.add(fileName);
            }
            catch (Exception e) {
                this.log.error((Object)("Failed to create subdeployment for " + fileName), (Throwable)e);
            }
        }
        return names;
    }

    protected void _processNestedDeployments(DeploymentInfo di) throws DeploymentException {
        File directory = NuxeoDeployer.getEarDirectory(di);
        for (String fileName : directory.list()) {
            try {
                if (!fileName.endsWith("-bundle.xml")) continue;
                this.log.info((Object)("Found XML bundle subdeployment: " + fileName));
                new DeploymentInfo(new URL(di.url, fileName), di, this.getServer());
            }
            catch (Exception e) {
                this.log.error((Object)("Failed to create subdeployment for " + fileName), (Throwable)e);
            }
        }
    }

    public static boolean canPreprocess(DeploymentInfo di) {
        return di.context.containsKey("EAR_PREPROCESSING");
    }

    public static boolean hasContainerDescriptor(DeploymentInfo di) {
        return di.localCl.findResource("OSGI-INF/deployment-container.xml") != null;
    }

    public final boolean isPreprocessingEnabled(DeploymentInfo di) {
        try {
            return this.debug || NuxeoDeployer.isFirstRun(di);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    protected static File getEarDirectory(DeploymentInfo di) throws DeploymentException {
        try {
            String url = di.localUrl.toString();
            url = url.replace(" ", "%20");
            return new File(new URI(url));
        }
        catch (Exception e) {
            throw new DeploymentException("Cannot get deploying directory: " + di.shortName, (Throwable)e);
        }
    }

    protected static File getPredeployStatusFile(DeploymentInfo di) throws DeploymentException {
        return new File(NuxeoDeployer.getEarDirectory(di), ".predeploy");
    }

    protected static boolean isFirstRun(DeploymentInfo di) throws DeploymentException {
        return !NuxeoDeployer.getPredeployStatusFile(di).exists();
    }

    protected static void writeStatusFile(DeploymentInfo di) throws DeploymentException {
        File file = NuxeoDeployer.getPredeployStatusFile(di);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (Exception e) {
                throw new DeploymentException("Cannot create predeployment status file for: " + di.shortName, (Throwable)e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DeploymentSorter
    implements Comparator<DeploymentInfo> {
        private final Map<String, Integer> map = new HashMap<String, Integer>();

        DeploymentSorter(ContainerDescriptor container) {
            int i = 0;
            for (DependencyTree.Entry<String, FragmentDescriptor> entry : container.fragments.getResolvedEntries()) {
                FragmentDescriptor fd = (FragmentDescriptor)entry.get();
                this.map.put(fd.name, i++);
            }
            this.map.put("org.nuxeo.osgi", -1);
        }

        public void addFirst(Collection<String> deploymentNames) {
            for (String name : deploymentNames) {
                this.map.put(name, -1);
            }
        }

        public void addLast(Collection<String> deploymentNames) {
            for (String name : deploymentNames) {
                this.map.put(name, Integer.MAX_VALUE);
            }
        }

        public void addFirst(String deploymentName) {
            this.map.put(deploymentName, -1);
        }

        public void addLast(String deploymentName) {
            this.map.put(deploymentName, Integer.MAX_VALUE);
        }

        @Override
        public int compare(DeploymentInfo o1, DeploymentInfo o2) {
            String name2;
            String name1 = NuxeoDeployer.this.processor.getJarId(o1.shortName);
            if (name1 == null) {
                name1 = o1.shortName;
            }
            if ((name2 = NuxeoDeployer.this.processor.getJarId(o2.shortName)) == null) {
                name2 = o2.shortName;
            }
            Integer k1 = this.map.get(name1);
            Integer k2 = this.map.get(name2);
            if (k1 == null) {
                k1 = -1;
            }
            if (k2 == null) {
                k2 = -1;
            }
            return k1 - k2;
        }
    }
}

