/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.jboss.deployment.preprocessor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.common.collections.DependencyTree;
import org.nuxeo.runtime.jboss.deployment.preprocessor.FragmentDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FragmentRegistry
extends DependencyTree<String, FragmentDescriptor> {
    protected final Map<String, FragmentDescriptor> fragments = new HashMap<String, FragmentDescriptor>();

    public void add(FragmentDescriptor fragment) {
        this.fragments.put(fragment.name, fragment);
    }

    public List<DependencyTree.Entry<String, FragmentDescriptor>> getResolvedEntries() {
        if (!this.fragments.isEmpty()) {
            this.commitFragments();
        }
        return super.getResolvedEntries();
    }

    public List<DependencyTree.Entry<String, FragmentDescriptor>> getMissingRequirements() {
        if (!this.fragments.isEmpty()) {
            this.commitFragments();
        }
        return super.getMissingRequirements();
    }

    public FragmentDescriptor get(String key) {
        if (!this.fragments.isEmpty()) {
            this.commitFragments();
        }
        return (FragmentDescriptor)super.get((Object)key);
    }

    public Collection<DependencyTree.Entry<String, FragmentDescriptor>> getEntries() {
        if (!this.fragments.isEmpty()) {
            this.commitFragments();
        }
        return super.getEntries();
    }

    public List<FragmentDescriptor> getResolvedObjects() {
        if (!this.fragments.isEmpty()) {
            this.commitFragments();
        }
        return super.getResolvedObjects();
    }

    public List<FragmentDescriptor> getPendingObjects() {
        if (!this.fragments.isEmpty()) {
            this.commitFragments();
        }
        return super.getPendingObjects();
    }

    public DependencyTree.Entry<String, FragmentDescriptor> getEntry(String key) {
        if (!this.fragments.isEmpty()) {
            this.commitFragments();
        }
        return super.getEntry((Object)key);
    }

    public List<DependencyTree.Entry<String, FragmentDescriptor>> getPendingEntries() {
        if (!this.fragments.isEmpty()) {
            this.commitFragments();
        }
        return super.getPendingEntries();
    }

    protected void commitFragments() {
        for (FragmentDescriptor fd : this.fragments.values()) {
            if (fd.requiredBy == null || fd.requiredBy.length <= 0) continue;
            for (String reqBy : fd.requiredBy) {
                FragmentDescriptor fdRegBy = this.fragments.get(reqBy);
                if (fdRegBy == null) continue;
                if (fdRegBy.requires == null) {
                    fdRegBy.requires = new ArrayList<String>();
                }
                fdRegBy.requires.add(fd.name);
            }
        }
        for (FragmentDescriptor fd : this.fragments.values()) {
            this.add(fd.name, fd, fd.requires);
        }
        this.fragments.clear();
    }
}

