/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.jboss.deployment.preprocessor.template;

import java.util.LinkedHashMap;
import java.util.Map;
import org.nuxeo.common.utils.TextTemplate;
import org.nuxeo.runtime.jboss.deployment.preprocessor.template.TemplateContribution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Template {
    public static final String BEGIN = "BEGIN";
    public static final String END = "END";
    final LinkedHashMap<String, Part> parts = new LinkedHashMap();

    public void addPart(String name, String text) {
        this.parts.put(name, new Part(name, text));
    }

    public void update(TemplateContribution tc, Map<String, String> ctx) {
        String content = new TextTemplate(ctx).process((CharSequence)tc.getContent());
        if (tc.isAppending()) {
            this.appendText(tc.getMarker(), content);
        } else if (tc.isPrepending()) {
            this.prependText(tc.getMarker(), content);
        } else if (tc.isReplacing()) {
            this.replaceText(tc.getMarker(), content);
        }
    }

    public void appendText(String marker, String text) {
        Part part = this.parts.get(marker);
        if (part != null) {
            part.append(text);
        } else {
            System.out.println("TODO >>>>>>>>>>>>> could not finnd marker " + marker);
        }
    }

    public void prependText(String marker, String text) {
        Part part = this.parts.get(marker);
        if (part != null) {
            part.prepend(text);
        } else {
            System.out.println("TODO >>>>>>>>>>>>> could not find marker " + marker);
        }
    }

    public void replaceText(String marker, String text) {
        Part part = this.parts.get(marker);
        if (part != null) {
            part.replace(text);
        } else {
            System.out.println("TODO >>>>>>>>>>>>> could not find marker " + marker);
        }
    }

    public String getText() {
        StringBuffer buf = new StringBuffer();
        for (Part part : this.parts.values()) {
            buf.append(part.text);
        }
        return buf.toString();
    }

    static class Part {
        public final String name;
        public final StringBuffer text;
        public final int offset;

        Part(String name, String text) {
            this.name = name;
            this.text = text == null ? new StringBuffer() : new StringBuffer(text);
            this.offset = this.text.length();
        }

        public void append(String text) {
            this.text.append(text);
        }

        public void prepend(String text) {
            this.text.insert(this.offset, text);
        }

        public void replace(String text) {
            this.text.replace(this.offset, this.text.length(), text);
        }

        public String getText() {
            return this.text.toString();
        }

        public String getName() {
            return this.name;
        }
    }
}

