/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.jboss.deployment;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.deployment.DeploymentSorter;
import org.jboss.system.server.ServerConfig;
import org.jboss.system.server.ServerConfigLocator;

public class NuxeoDeploymentSorter
extends DeploymentSorter
implements Serializable {
    private static final long serialVersionUID = 4635486588780702177L;
    private static final Log log = LogFactory.getLog(NuxeoDeploymentSorter.class);
    private final Map<String, Integer> bundlesOrder = new HashMap<String, Integer>();

    public NuxeoDeploymentSorter() {
        ServerConfig config = ServerConfigLocator.locate();
        try {
            URL configFile = new URL(config.getServerConfigURL(), "deployment-order");
            this.loadConfigFile(configFile);
        }
        catch (Exception e) {
            log.warn((Object)"Failed to load deployment-order file");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfigFile(URL configFile) throws IOException {
        InputStream in = configFile.openStream();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(in));
            String line = reader.readLine().trim();
            int i = 0;
            while (line != null) {
                if (line.length() > 0 && line.charAt(0) != '#') {
                    this.bundlesOrder.put(line, i++);
                }
                line = reader.readLine();
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    private static String getFileName(URL url) {
        String path = url.getPath();
        int len = path.length();
        if (len == 0) {
            return "";
        }
        int offset = path.charAt(len - 1) == '/' ? len - 2 : len - 1;
        int p = path.lastIndexOf(47, offset);
        if (p > -1) {
            return path.substring(p + 1);
        }
        return path;
    }

    public int compare(Object o1, Object o2) {
        URL u1 = (URL)o1;
        URL u2 = (URL)o2;
        String name1 = NuxeoDeploymentSorter.getFileName(u1);
        Integer i1 = this.bundlesOrder.get(name1);
        if (i1 != null) {
            String name2 = NuxeoDeploymentSorter.getFileName(u2);
            Integer i2 = this.bundlesOrder.get(name2);
            if (i2 != null) {
                return i1 - i2;
            }
            return 1;
        }
        String name2 = NuxeoDeploymentSorter.getFileName(u2);
        Integer i2 = this.bundlesOrder.get(name2);
        if (i2 != null) {
            return -1;
        }
        int order = this.getExtensionIndex(u1) - this.getExtensionIndex(u2);
        if (order != 0) {
            return order;
        }
        return u1.getFile().compareTo(u2.getFile());
    }
}

